/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.InMemoryEvaluator;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuerySpec {
    private Class<?> resourceClass;
    private String resourceType;
    private List<FilterSpec> filters = new ArrayList<FilterSpec>();
    private List<SortSpec> sort = new ArrayList<SortSpec>();
    private List<IncludeFieldSpec> includedFields = new ArrayList<IncludeFieldSpec>();
    private List<IncludeRelationSpec> includedRelations = new ArrayList<IncludeRelationSpec>();
    private Map<Object, QuerySpec> relatedSpecs = new HashMap<Object, QuerySpec>();
    private PagingSpec pagingSpec;

    public QuerySpec(Class<?> resourceClass) {
        this(resourceClass, null);
    }

    public QuerySpec(String resourceType) {
        this(null, resourceType);
    }

    public QuerySpec(Class<?> resourceClass, String resourceType) {
        QuerySpec.verifyNotNull(resourceClass, resourceType);
        if (resourceClass != Resource.class) {
            this.resourceClass = resourceClass;
        }
        this.resourceType = resourceType;
        this.pagingSpec = new OffsetLimitPagingSpec();
    }

    public QuerySpec(ResourceInformation resourceInformation) {
        this(resourceInformation.getResourceClass(), resourceInformation.getResourceType());
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public <T> DefaultResourceList<T> apply(Iterable<T> resources) {
        DefaultResourceList resultList = new DefaultResourceList();
        resultList.setMeta(new DefaultPagedMetaInformation());
        this.apply(resources, resultList);
        return resultList;
    }

    public <T> void apply(Iterable<T> resources, ResourceList<T> resultList) {
        InMemoryEvaluator eval = new InMemoryEvaluator();
        eval.eval(resources, this, resultList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 31 * result + (this.includedFields == null ? 0 : this.includedFields.hashCode());
        result = 31 * result + (this.includedRelations == null ? 0 : this.includedRelations.hashCode());
        result = 31 * result + (this.pagingSpec == null ? 0 : this.pagingSpec.hashCode());
        result = 31 * result + (this.relatedSpecs == null ? 0 : this.relatedSpecs.hashCode());
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpec other = (QuerySpec)obj;
        return CompareUtils.isEquals(this.filters, other.filters) && CompareUtils.isEquals(this.includedFields, other.includedFields) && CompareUtils.isEquals(this.includedRelations, other.includedRelations) && CompareUtils.isEquals(this.pagingSpec, other.pagingSpec) && CompareUtils.isEquals(this.relatedSpecs, other.relatedSpecs) && CompareUtils.isEquals(this.sort, other.sort);
    }

    public Long getLimit() {
        if (this.pagingSpec instanceof OffsetLimitPagingSpec) {
            return ((OffsetLimitPagingSpec)this.pagingSpec).getLimit();
        }
        throw new UnsupportedOperationException("Not instance of OffsetLimitPagingSpec");
    }

    public void setLimit(Long limit) {
        if (!(this.pagingSpec instanceof OffsetLimitPagingSpec)) {
            throw new UnsupportedOperationException("Not instance of  OffsetLimitPagingSpec");
        }
        ((OffsetLimitPagingSpec)this.pagingSpec).setLimit(limit);
    }

    public long getOffset() {
        if (this.pagingSpec instanceof OffsetLimitPagingSpec) {
            return ((OffsetLimitPagingSpec)this.pagingSpec).getOffset();
        }
        throw new UnsupportedOperationException("Not instance of OffsetLimitPagingSpec");
    }

    public void setOffset(long offset) {
        if (!(this.pagingSpec instanceof OffsetLimitPagingSpec)) {
            throw new UnsupportedOperationException("Not instance of OffsetLimitPagingSpec");
        }
        ((OffsetLimitPagingSpec)this.pagingSpec).setOffset(offset);
    }

    public PagingSpec getPagingSpec() {
        return this.pagingSpec;
    }

    public QuerySpec setPagingSpec(PagingSpec pagingSpec) {
        this.pagingSpec = pagingSpec;
        return this;
    }

    public List<FilterSpec> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterSpec> filters) {
        this.filters = filters;
    }

    public FilterSpec getFilter(String name) {
        for (FilterSpec filterSpec : this.filters) {
            if (!filterSpec.getAttributePath().contains(name)) continue;
            return filterSpec;
        }
        return null;
    }

    public FilterSpec getFilterOrThrow(String name) {
        FilterSpec filter = this.getFilter(name);
        if (filter == null) {
            throw new BadRequestException(String.format("Filter '%s' not found", name));
        }
        return filter;
    }

    public List<SortSpec> getSort() {
        return this.sort;
    }

    public void setSort(List<SortSpec> sort) {
        this.sort = sort;
    }

    public List<IncludeFieldSpec> getIncludedFields() {
        return this.includedFields;
    }

    public void setIncludedFields(List<IncludeFieldSpec> includedFields) {
        this.includedFields = includedFields;
    }

    public List<IncludeRelationSpec> getIncludedRelations() {
        return this.includedRelations;
    }

    public void setIncludedRelations(List<IncludeRelationSpec> includedRelations) {
        this.includedRelations = includedRelations;
    }

    @Deprecated
    public Map<Class<?>, QuerySpec> getRelatedSpecs() {
        return this.relatedSpecs;
    }

    public Collection<QuerySpec> getNestedSpecs() {
        return Collections.unmodifiableCollection(this.relatedSpecs.values());
    }

    public void setNestedSpecs(Collection<QuerySpec> specs) {
        this.relatedSpecs.clear();
        for (QuerySpec spec : specs) {
            if (spec.getResourceClass() != null) {
                this.relatedSpecs.put(spec.getResourceClass(), spec);
                continue;
            }
            this.relatedSpecs.put(spec.getResourceType(), spec);
        }
    }

    @Deprecated
    public void setRelatedSpecs(Map<Class<?>, QuerySpec> relatedSpecs) {
        this.relatedSpecs = relatedSpecs;
    }

    public void addFilter(FilterSpec filterSpec) {
        this.filters.add(filterSpec);
    }

    public void addSort(SortSpec sortSpec) {
        this.sort.add(sortSpec);
    }

    public void includeField(List<String> attrPath) {
        this.includedFields.add(new IncludeFieldSpec(attrPath));
    }

    public void includeRelation(List<String> attrPath) {
        this.includedRelations.add(new IncludeRelationSpec(attrPath));
    }

    public QuerySpec getQuerySpec(String resourceType) {
        if (resourceType.equals(this.resourceType)) {
            return this;
        }
        return this.relatedSpecs.get(resourceType);
    }

    public QuerySpec getQuerySpec(Class<?> resourceClass) {
        if (resourceClass.equals(this.resourceClass)) {
            return this;
        }
        return this.relatedSpecs.get(resourceClass);
    }

    public QuerySpec getQuerySpec(ResourceInformation resourceInformation) {
        QuerySpec querySpec = this.getQuerySpec(resourceInformation.getResourceType());
        if (querySpec == null) {
            querySpec = this.getQuerySpec(resourceInformation.getResourceClass());
        }
        return querySpec;
    }

    public QuerySpec getOrCreateQuerySpec(String resourceType) {
        return this.getOrCreateQuerySpec(null, resourceType);
    }

    public QuerySpec getOrCreateQuerySpec(ResourceInformation resourceInformation) {
        return this.getOrCreateQuerySpec(resourceInformation.getResourceClass(), resourceInformation.getResourceType());
    }

    public QuerySpec getOrCreateQuerySpec(Class<?> targetResourceClass) {
        return this.getOrCreateQuerySpec(targetResourceClass, null);
    }

    public QuerySpec getOrCreateQuerySpec(Class<?> targetResourceClass, String targetResourceType) {
        QuerySpec.verifyNotNull(targetResourceClass, targetResourceType);
        QuerySpec querySpec = null;
        if (querySpec == null && targetResourceType != null) {
            querySpec = this.getQuerySpec(targetResourceType);
        }
        if (targetResourceClass != null) {
            querySpec = this.getQuerySpec(targetResourceClass);
        }
        if (querySpec == null) {
            querySpec = new QuerySpec(targetResourceClass, targetResourceType);
            if (targetResourceClass != null) {
                this.relatedSpecs.put(targetResourceClass, querySpec);
            }
            if (targetResourceType != null) {
                this.relatedSpecs.put(targetResourceType, querySpec);
            }
        }
        querySpec.setPagingSpec(this.pagingSpec);
        return querySpec;
    }

    private static void verifyNotNull(Class<?> targetResourceClass, String targetResourceType) {
        PreconditionUtil.assertNotNull("at least one parameter must not be null", targetResourceClass == null && targetResourceType == null);
        if (targetResourceClass == Resource.class && targetResourceType == null) {
            throw new IllegalArgumentException("must specify resourceType if io.crnk.core.engine.document.Resource is used");
        }
    }

    public void putRelatedSpec(Class<?> relatedResourceClass, QuerySpec relatedSpec) {
        if (relatedResourceClass.equals(this.resourceClass)) {
            throw new IllegalArgumentException("cannot set related spec with root resourceClass");
        }
        this.relatedSpecs.put(relatedResourceClass, relatedSpec);
    }

    @Deprecated
    public QuerySpec duplicate() {
        return this.clone();
    }

    public QuerySpec clone() {
        QuerySpec copy = new QuerySpec(this.resourceClass);
        if (this.pagingSpec != null) {
            copy.pagingSpec = this.pagingSpec.clone();
        }
        copy.includedFields.addAll(this.includedFields);
        copy.includedRelations.addAll(this.includedRelations);
        for (SortSpec sortSpec : this.sort) {
            copy.sort.add(sortSpec.clone());
        }
        for (FilterSpec filterSpec : this.filters) {
            copy.filters.add(filterSpec.clone());
        }
        for (Map.Entry<Object, QuerySpec> entry : this.relatedSpecs.entrySet()) {
            copy.relatedSpecs.put(entry.getKey(), entry.getValue().duplicate());
        }
        return copy;
    }

    public String toString() {
        return "QuerySpec{" + (this.resourceClass != null ? "resourceClass=" + this.resourceClass.getName() : "") + (this.resourceType != null ? "resourceType=" + this.resourceType : "") + (this.pagingSpec != null ? ", paging=" + this.pagingSpec : "") + (!this.filters.isEmpty() ? ", filters=" + this.filters : "") + (!this.sort.isEmpty() ? ", sort=" + this.sort : "") + (!this.includedFields.isEmpty() ? ", includedFields=" + this.includedFields : "") + (!this.includedRelations.isEmpty() ? ", includedRelations=" + this.includedRelations : "") + (!this.relatedSpecs.isEmpty() ? ", relatedSpecs=" + this.relatedSpecs : "") + '}';
    }
}

