/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.legacy.queryParams.DefaultQueryParamsConverter;
import io.crnk.legacy.queryParams.QueryParams;
import io.crnk.legacy.queryParams.include.Inclusion;
import io.crnk.legacy.queryParams.params.IncludedFieldsParams;
import io.crnk.legacy.queryParams.params.IncludedRelationsParams;
import io.crnk.legacy.queryParams.params.TypedParams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class QuerySpecAdapter
implements QueryAdapter {
    private final QueryContext queryContext;
    private QuerySpec querySpec;
    private ResourceRegistry resourceRegistry;
    private boolean compactMode;

    public QuerySpecAdapter(QuerySpec querySpec, ResourceRegistry resourceRegistry, QueryContext queryContext) {
        this.querySpec = querySpec;
        this.resourceRegistry = resourceRegistry;
        this.queryContext = Objects.requireNonNull(queryContext);
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    @Override
    public TypedParams<IncludedRelationsParams> getIncludedRelations() {
        HashMap<String, IncludedRelationsParams> params = new HashMap<String, IncludedRelationsParams>();
        if (this.querySpec != null) {
            this.addRelations(params, this.querySpec);
            for (QuerySpec relatedSpec : this.querySpec.getNestedSpecs()) {
                this.addRelations(params, relatedSpec);
            }
        }
        return new TypedParams<IncludedRelationsParams>(params);
    }

    private void addRelations(Map<String, IncludedRelationsParams> params, QuerySpec spec) {
        if (!spec.getIncludedRelations().isEmpty()) {
            HashSet<Inclusion> set = new HashSet<Inclusion>();
            for (IncludeRelationSpec relation : spec.getIncludedRelations()) {
                set.add(new Inclusion(StringUtils.join(".", relation.getAttributePath())));
            }
            params.put(this.getResourceType(spec), new IncludedRelationsParams(set));
        }
    }

    private String getResourceType(QuerySpec spec) {
        if (spec.getResourceType() != null) {
            return spec.getResourceType();
        }
        RegistryEntry entry = this.resourceRegistry.getEntry(spec.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.getResourceType();
    }

    @Override
    public TypedParams<IncludedFieldsParams> getIncludedFields() {
        HashMap<String, IncludedFieldsParams> params = new HashMap<String, IncludedFieldsParams>();
        if (this.querySpec != null) {
            this.addFields(params, this.querySpec);
            for (QuerySpec relatedSpec : this.querySpec.getNestedSpecs()) {
                this.addFields(params, relatedSpec);
            }
        }
        return new TypedParams<IncludedFieldsParams>(params);
    }

    private void addFields(Map<String, IncludedFieldsParams> params, QuerySpec spec) {
        if (!spec.getIncludedFields().isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            for (IncludeFieldSpec relation : spec.getIncludedFields()) {
                set.add(StringUtils.join(".", relation.getAttributePath()));
            }
            params.put(this.getResourceType(spec), new IncludedFieldsParams(set));
        }
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceRegistry.getEntry(this.getResourceType(this.querySpec)).getResourceInformation();
    }

    @Override
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Override
    public Long getLimit() {
        return this.querySpec.getLimit();
    }

    @Override
    public void setLimit(Long limit) {
        this.querySpec.setLimit(limit);
    }

    @Override
    public long getOffset() {
        return this.querySpec.getOffset();
    }

    @Override
    public void setOffset(long offset) {
        this.querySpec.setOffset(offset);
    }

    @Override
    public QueryAdapter duplicate() {
        QuerySpecAdapter adapter = new QuerySpecAdapter(this.querySpec != null ? this.querySpec.duplicate() : null, this.resourceRegistry, this.queryContext);
        adapter.setCompactMode(this.compactMode);
        return adapter;
    }

    @Override
    public QueryParams toQueryParams() {
        DefaultQueryParamsConverter converter = new DefaultQueryParamsConverter(this.resourceRegistry);
        return converter.fromParams(this.getResourceInformation().getResourceClass(), this.getQuerySpec());
    }

    @Override
    public QuerySpec toQuerySpec() {
        return this.getQuerySpec();
    }

    @Override
    public boolean getCompactMode() {
        return this.compactMode;
    }

    @Override
    public void setPagingSpec(PagingSpec pagingSpec) {
        this.querySpec.setPagingSpec(pagingSpec);
    }

    @Override
    public PagingSpec getPagingSpec() {
        return this.querySpec.getPagingSpec();
    }

    @Override
    public boolean isEmpty() {
        return this.querySpec == null;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public String toString() {
        return this.querySpec.toString();
    }
}

