/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.information.resource.ResourceInformationProviderModule;
import io.crnk.core.engine.internal.CoreModule;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.controller.CollectionGet;
import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.controller.ControllerContext;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourcePost;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceDelete;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourcePatch;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourcePost;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceDelete;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceGet;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePatch;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePost;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.HttpRequestDispatcherImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessor;
import io.crnk.core.engine.internal.jackson.JacksonModule;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.DefaultResourceRegistryPart;
import io.crnk.core.engine.registry.HierarchicalResourceRegistryPart;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.DefaultServiceDiscoveryFactory;
import io.crnk.core.module.discovery.FallbackServiceDiscoveryFactory;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.discovery.ServiceDiscoveryFactory;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.internal.QuerySpecAdapterBuilder;
import io.crnk.core.queryspec.internal.UrlMapperAdapter;
import io.crnk.core.queryspec.mapper.DefaultQuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UnkonwnMappingAware;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.repository.Repository;
import io.crnk.legacy.internal.QueryParamsAdapterBuilder;
import io.crnk.legacy.locator.JsonServiceLocator;
import io.crnk.legacy.locator.SampleJsonServiceLocator;
import io.crnk.legacy.queryParams.QueryParamsBuilder;
import io.crnk.legacy.repository.annotations.JsonApiRelationshipRepository;
import io.crnk.legacy.repository.annotations.JsonApiResourceRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrnkBoot {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkBoot.class);
    private final ModuleRegistry moduleRegistry = new ModuleRegistry();
    private ObjectMapper objectMapper;
    private QueryParamsBuilder queryParamsBuilder;
    private boolean configured;
    private JsonServiceLocator serviceLocator = new SampleJsonServiceLocator();
    private ResourceRegistry resourceRegistry;
    private HttpRequestDispatcherImpl requestDispatcher;
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ServiceDiscoveryFactory serviceDiscoveryFactory = new DefaultServiceDiscoveryFactory();
    private ServiceDiscovery serviceDiscovery;
    private DocumentMapper documentMapper;
    private List<Module> registeredModules = new ArrayList<Module>();
    private Long defaultPageLimit = null;
    private Long maxPageLimit = null;
    private Boolean allowUnknownAttributes;
    private Boolean allowUnknownParameters;
    private QueryAdapterBuilder queryAdapterBuilder;
    private CoreModule coreModule = new CoreModule();
    private Map<String, String> serverInfo = new HashMap<String, String>();
    private ControllerRegistry controllerRegistry;

    private static String buildServiceUrl(String resourceDefaultDomain, String webPathPrefix) {
        return resourceDefaultDomain + (webPathPrefix != null ? webPathPrefix : "");
    }

    public void putServerInfo(String key, String value) {
        this.serverInfo.put(key, value);
        this.moduleRegistry.setServerInfo(this.serverInfo);
    }

    public void setServiceDiscoveryFactory(ServiceDiscoveryFactory factory) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNull("serviceDiscovery already initialized", this.serviceDiscovery);
        this.serviceDiscoveryFactory = factory;
    }

    public void setQueryParamsBuilds(QueryParamsBuilder queryParamsBuilder) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query params builder must be provided, but is null", queryParamsBuilder);
        this.queryParamsBuilder = queryParamsBuilder;
        this.moduleRegistry.setUrlMapper(null);
    }

    public void setServiceLocator(JsonServiceLocator serviceLocator) {
        this.checkNotConfiguredYet();
        this.serviceLocator = serviceLocator;
    }

    public void addModule(Module module) {
        this.checkNotConfiguredYet();
        this.setupInstance(module);
        this.registeredModules.add(module);
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.checkNotConfiguredYet();
        this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(serviceUrlProvider);
    }

    private void checkNotConfiguredYet() {
        if (this.configured) {
            throw new IllegalStateException("cannot further modify CrnkBoot once configured/initialized");
        }
    }

    public void boot() {
        LOGGER.debug("performing setup");
        this.checkNotConfiguredYet();
        this.configured = true;
        this.moduleRegistry.setPropertiesProvider(this.propertiesProvider);
        this.setupServiceUrlProvider();
        this.setupServiceDiscovery();
        this.setupQuerySpecUrlMapper();
        this.setupPagingBehavior();
        this.bootDiscovery();
        LOGGER.debug("completed setup");
    }

    private void setupServiceDiscovery() {
        if (this.serviceDiscovery == null) {
            FallbackServiceDiscoveryFactory fallback = new FallbackServiceDiscoveryFactory(this.serviceDiscoveryFactory, this.serviceLocator, this.propertiesProvider);
            this.setServiceDiscovery(fallback.getInstance());
        }
    }

    private void bootDiscovery() {
        this.setupObjectMapper();
        this.resourceRegistry = new ResourceRegistryImpl(null, this.moduleRegistry);
        this.addModules();
        this.setupComponents();
        ResourceRegistryPart rootPart = this.setupResourceRegistry();
        this.moduleRegistry.init(this.objectMapper);
        this.setupRepositories(rootPart);
        this.requestDispatcher = this.createRequestDispatcher(this.moduleRegistry.getExceptionMapperRegistry());
    }

    private void setupRepositories(ResourceRegistryPart rootPart) {
        for (RegistryEntry entry : this.moduleRegistry.getRegistryEntries()) {
            rootPart.addEntry(entry);
        }
    }

    private ResourceRegistryPart setupResourceRegistry() {
        ResourceRegistryPartBase rootPart;
        Map<String, ResourceRegistryPart> registryParts = this.moduleRegistry.getRegistryParts();
        if (registryParts.isEmpty()) {
            rootPart = new DefaultResourceRegistryPart();
        } else {
            HierarchicalResourceRegistryPart hierarchialPart = new HierarchicalResourceRegistryPart();
            for (Map.Entry<String, ResourceRegistryPart> entry : registryParts.entrySet()) {
                hierarchialPart.putPart(entry.getKey(), entry.getValue());
            }
            if (!registryParts.containsKey("")) {
                this.moduleRegistry.getContext().addRegistryPart("", new DefaultResourceRegistryPart());
            }
            rootPart = hierarchialPart;
        }
        ((ResourceRegistryImpl)this.resourceRegistry).setRootPart(rootPart);
        return rootPart;
    }

    private void setupObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.findAndRegisterModules();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.moduleRegistry.setObjectMapper(this.objectMapper);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.moduleRegistry.getExceptionMapperRegistry();
    }

    private HttpRequestDispatcherImpl createRequestDispatcher(ExceptionMapperRegistry exceptionMapperRegistry) {
        this.documentMapper = this.createDocumentMapper();
        return new HttpRequestDispatcherImpl(this.moduleRegistry, exceptionMapperRegistry);
    }

    protected QueryAdapterBuilder createQueryAdapterBuilder() {
        if (this.queryParamsBuilder != null) {
            return new QueryParamsAdapterBuilder(this.queryParamsBuilder, this.moduleRegistry);
        }
        return new QuerySpecAdapterBuilder(this.moduleRegistry.getUrlMapper(), this.moduleRegistry);
    }

    protected DocumentMapper createDocumentMapper() {
        ResourceFilterDirectory filterDirectory = this.moduleRegistry.getContext().getResourceFilterDirectory();
        ResultFactory resultFactory = this.moduleRegistry.getContext().getResultFactory();
        return new DocumentMapper(this.resourceRegistry, this.objectMapper, this.propertiesProvider, filterDirectory, resultFactory, this.serverInfo);
    }

    protected ControllerRegistry createControllerRegistry() {
        HashSet<Controller> controllers = new HashSet<Controller>();
        controllers.add(new RelationshipsResourceDelete());
        controllers.add(new RelationshipsResourcePatch());
        controllers.add(new RelationshipsResourcePost());
        controllers.add(new ResourceDelete());
        controllers.add(new CollectionGet());
        controllers.add(new FieldResourceGet());
        controllers.add(new RelationshipsResourceGet());
        controllers.add(new ResourceGet());
        controllers.add(new FieldResourcePost());
        controllers.add(new ResourcePatch());
        controllers.add(new ResourcePost());
        ControllerContext context = new ControllerContext(this.moduleRegistry, this::getDocumentMapper);
        for (Controller controller : controllers) {
            controller.init(context);
        }
        return new ControllerRegistry(controllers);
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    private void setupComponents() {
        Annotation annotation;
        LOGGER.debug("performing service discovery with {}", (Object)this.serviceDiscovery);
        SimpleModule module = new SimpleModule("discovery"){

            @Override
            public void setupModule(Module.ModuleContext context) {
                CrnkBoot.this.controllerRegistry = CrnkBoot.this.createControllerRegistry();
                CrnkBoot.this.queryAdapterBuilder = CrnkBoot.this.createQueryAdapterBuilder();
                this.addHttpRequestProcessor(new JsonApiRequestProcessor(context, CrnkBoot.this.controllerRegistry, CrnkBoot.this.queryAdapterBuilder));
                super.setupModule(context);
            }
        };
        for (JsonApiExceptionMapper exceptionMapper : this.getInstancesByType(JsonApiExceptionMapper.class)) {
            module.addExceptionMapper(exceptionMapper);
        }
        for (DocumentFilter filter : this.getInstancesByType(DocumentFilter.class)) {
            module.addFilter(filter);
        }
        List<Repository> repositories = this.getInstancesByType(Repository.class);
        for (Repository repository : repositories) {
            module.addRepository(repository);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiResourceRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiResourceRepository.class).get();
            Class<?> resourceClass = annotation.value();
            module.addRepository(resourceClass, object);
        }
        for (Object object : this.serviceDiscovery.getInstancesByAnnotation(JsonApiRelationshipRepository.class)) {
            annotation = ClassUtils.getAnnotation(object.getClass(), JsonApiRelationshipRepository.class).get();
            module.addRepository(annotation.source(), annotation.target(), object);
        }
        this.moduleRegistry.addModule(module);
        this.moduleRegistry.addModule(new ResourceInformationProviderModule());
    }

    private <T> List<T> getInstancesByType(Class<T> clazz) {
        List<T> instancesByType = this.serviceDiscovery.getInstancesByType(clazz);
        for (T instance : instancesByType) {
            this.setupInstance(instance);
        }
        return instancesByType;
    }

    private <T> void setupInstance(T instance) {
        if (instance instanceof HttpRequestContextAware) {
            HttpRequestContextAware aware = (HttpRequestContextAware)instance;
            aware.setHttpRequestContextProvider(this.moduleRegistry.getHttpRequestContextProvider());
        }
    }

    private void addModules() {
        boolean serializeLinksAsObjects = Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.serialize.object.links"));
        this.moduleRegistry.addModule(new JacksonModule(this.objectMapper, serializeLinksAsObjects));
        this.moduleRegistry.addModule(this.coreModule);
        for (Module module : this.registeredModules) {
            this.moduleRegistry.addModule(module);
        }
        List<Module> discoveredModules = this.getInstancesByType(Module.class);
        for (Module module : discoveredModules) {
            this.moduleRegistry.addModule(module);
        }
    }

    private void setupServiceUrlProvider() {
        String resourceDefaultDomain = this.propertiesProvider.getProperty("crnk.config.core.resource.domain");
        String webPathPrefix = this.getWebPathPrefix();
        if (resourceDefaultDomain != null) {
            String serviceUrl = CrnkBoot.buildServiceUrl(resourceDefaultDomain, webPathPrefix);
            this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(new ConstantServiceUrlProvider(serviceUrl));
        }
    }

    public HttpRequestDispatcherImpl getRequestDispatcher() {
        PreconditionUtil.assertNotNull("expected requestDispatcher", this.requestDispatcher);
        return this.requestDispatcher;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNull("ObjectMapper already set", this.objectMapper);
        this.objectMapper = objectMapper;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.checkNotConfiguredYet();
        LOGGER.debug("set properties provider {}", (Object)propertiesProvider);
        this.propertiesProvider = propertiesProvider;
    }

    @Deprecated
    public ServiceUrlProvider getDefaultServiceUrlProvider() {
        return this.getServiceUrlProvider();
    }

    @Deprecated
    public void setDefaultServiceUrlProvider(ServiceUrlProvider defaultServiceUrlProvider) {
        this.setServiceUrlProvider(defaultServiceUrlProvider);
    }

    public String getWebPathPrefix() {
        return this.propertiesProvider.getProperty("crnk.config.web.path.prefix");
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.moduleRegistry.getServiceDiscovery();
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        LOGGER.debug("set service discovery {}", (Object)serviceDiscovery);
        PreconditionUtil.assertNull("already set", this.serviceDiscovery);
        this.serviceDiscovery = serviceDiscovery;
        this.moduleRegistry.setServiceDiscovery(serviceDiscovery);
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        PreconditionUtil.assertNull("Setting the default page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.queryParamsBuilder);
        this.defaultPageLimit = defaultPageLimit;
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        PreconditionUtil.assertNull("Setting the max page limit requires using the QuerySpecDeserializer, but it is null. Are you using QueryParams instead?", this.queryParamsBuilder);
        this.maxPageLimit = maxPageLimit;
    }

    public void setAllowUnknownAttributes() {
        PreconditionUtil.assertNull("Allow unknown attributes requires using the QuerySpecDeserializer, but it is null.", this.queryParamsBuilder);
        this.allowUnknownAttributes = true;
    }

    public void setAllowUnknownParameters() {
        PreconditionUtil.assertNull("Allow unknown parameters requires using the QuerySpecDeserializer, but it is null.", this.queryParamsBuilder);
        this.allowUnknownParameters = true;
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    @Deprecated
    public QuerySpecDeserializer getQuerySpecDeserializer() {
        QuerySpecUrlMapper urlMapper = this.getUrlMapper();
        if (urlMapper instanceof UrlMapperAdapter) {
            return ((UrlMapperAdapter)urlMapper).getDeserializer();
        }
        return (QuerySpecDeserializer)((Object)urlMapper);
    }

    private void setupQuerySpecUrlMapper() {
        QuerySpecUrlMapper urlMapper;
        if (this.moduleRegistry.getUrlMapper() == null) {
            this.setupServiceDiscovery();
            List<QuerySpecUrlMapper> list = this.serviceDiscovery.getInstancesByType(QuerySpecUrlMapper.class);
            if (list.isEmpty()) {
                List<QuerySpecDeserializer> deserializers = this.serviceDiscovery.getInstancesByType(QuerySpecDeserializer.class);
                if (deserializers.isEmpty()) {
                    this.moduleRegistry.setUrlMapper(new DefaultQuerySpecUrlMapper());
                } else {
                    this.setQuerySpecDeserializerUnchecked(deserializers.get(0));
                }
            } else {
                this.moduleRegistry.setUrlMapper(list.get(0));
            }
        }
        if ((urlMapper = this.moduleRegistry.getUrlMapper()) instanceof UnkonwnMappingAware) {
            String strAllow;
            if (this.allowUnknownAttributes == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownAttributes")) != null) {
                this.allowUnknownAttributes = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownAttributes != null) {
                ((UnkonwnMappingAware)((Object)urlMapper)).setAllowUnknownAttributes(this.allowUnknownAttributes);
            }
            if (this.allowUnknownParameters == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownParameters")) != null) {
                this.allowUnknownParameters = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownParameters != null) {
                ((UnkonwnMappingAware)((Object)urlMapper)).setAllowUnknownParameters(this.allowUnknownParameters);
            }
        }
    }

    private void setupPagingBehavior() {
        this.setupServiceDiscovery();
        this.moduleRegistry.addAllPagingBehaviors(this.serviceDiscovery.getInstancesByType(PagingBehavior.class));
        if (!this.moduleRegistry.getPagingBehaviors().stream().anyMatch(it -> it instanceof OffsetLimitPagingBehavior)) {
            this.moduleRegistry.addPagingBehavior(new OffsetLimitPagingBehavior());
        }
        for (PagingBehavior pagingBehavior : this.moduleRegistry.getPagingBehaviors()) {
            if (!(pagingBehavior instanceof OffsetLimitPagingBehavior)) continue;
            if (this.defaultPageLimit != null) {
                ((OffsetLimitPagingBehavior)pagingBehavior).setDefaultLimit(this.defaultPageLimit);
            }
            if (this.maxPageLimit == null) continue;
            ((OffsetLimitPagingBehavior)pagingBehavior).setMaxPageLimit(this.maxPageLimit);
        }
    }

    @Deprecated
    public void setQuerySpecDeserializer(QuerySpecDeserializer querySpecDeserializer) {
        this.checkNotConfiguredYet();
        this.setQuerySpecDeserializerUnchecked(querySpecDeserializer);
    }

    private void setQuerySpecDeserializerUnchecked(QuerySpecDeserializer querySpecDeserializer) {
        PreconditionUtil.assertNotNull("A query spec deserializer must be provided, but is null", querySpecDeserializer);
        this.moduleRegistry.setUrlMapper(new UrlMapperAdapter(querySpecDeserializer));
        this.queryParamsBuilder = null;
    }

    public void setUrlMapper(QuerySpecUrlMapper urlMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.assertNotNull("A query spec deserializer must be provided, but is null", urlMapper);
        this.moduleRegistry.setUrlMapper(urlMapper);
        this.queryParamsBuilder = null;
    }

    public boolean isNullDataResponseEnabled() {
        return Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.null.data.response.enabled"));
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    public List<PagingBehavior> getPagingBehaviors() {
        return this.moduleRegistry.getPagingBehaviors();
    }

    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }

    public QueryAdapterBuilder getQueryAdapterBuilder() {
        return this.queryAdapterBuilder;
    }

    public CoreModule getCoreModule() {
        return this.coreModule;
    }

    public QuerySpecUrlMapper getUrlMapper() {
        this.setupQuerySpecUrlMapper();
        return this.moduleRegistry.getUrlMapper();
    }
}

