/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.controller.ControllerContext;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseController
implements Controller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ControllerContext context;

    @Override
    public void init(ControllerContext context) {
        this.context = context;
    }

    @Override
    @Deprecated
    public final Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestDocument) {
        Result<Response> response = this.handleAsync(jsonPath, queryAdapter, parameterProvider, requestDocument);
        PreconditionUtil.assertNotNull("no response by controller provided", response);
        return response.get();
    }

    protected void verifyTypes(HttpMethod methodType, RegistryEntry endpointRegistryEntry, RegistryEntry bodyRegistryEntry) {
        if (endpointRegistryEntry.equals(bodyRegistryEntry)) {
            return;
        }
        if (bodyRegistryEntry == null || !bodyRegistryEntry.isParent(endpointRegistryEntry)) {
            String message = String.format("Inconsistent type definition between path and body: body type: %s, request type: %s", bodyRegistryEntry.getResourceInformation().getResourceType(), endpointRegistryEntry.getResourceInformation().getResourceType());
            throw new RequestBodyException(methodType, endpointRegistryEntry.getResourceInformation().getResourceType(), message);
        }
    }

    protected RegistryEntry getRegistryEntry(String resource) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(resource);
        if (registryEntry == null) {
            throw new BadRequestException(String.format("Invalid resource type: %s", resource));
        }
        return registryEntry;
    }

    protected RegistryEntry getRegistryEntryByPath(String resourcePath) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntryByPath(resourcePath);
        if (registryEntry == null) {
            throw new RepositoryNotFoundException(resourcePath);
        }
        return registryEntry;
    }
}

