/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.Collections;

public abstract class RelationshipsResourceUpsert
extends ResourceIncludeField {
    protected abstract HttpMethod method();

    protected abstract Result processToManyRelationship(Result<Object> var1, ResourceInformation var2, ResourceField var3, Iterable<ResourceIdentifier> var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    protected abstract Result processToOneRelationship(Result<Object> var1, ResourceInformation var2, ResourceField var3, ResourceIdentifier var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    @Override
    public final boolean isAcceptable(JsonPath jsonPath, String method) {
        PreconditionUtil.assertNotNull("jsonPath cannot be null", jsonPath);
        return !jsonPath.isCollection() && RelationshipsPath.class.equals(jsonPath.getClass()) && this.method().name().equals(method);
    }

    @Override
    public final Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        Result result;
        String resourcePath = jsonPath.getResourcePath();
        PathIds strResourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.getRegistryEntryByPath(resourcePath);
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        this.assertRequestDocument(requestBody, HttpMethod.POST, resourcePath);
        Serializable resourceId = this.getResourceId(strResourceIds, registryEntry);
        ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(jsonPath.getElementName());
        RelationshipsResourceUpsert.verifyFieldNotNull(relationshipField, jsonPath.getElementName());
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        ResourceInformation targetInformation = this.getRegistryEntry(relationshipField.getOppositeResourceType()).getResourceInformation();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepository(relationshipField, parameterProvider);
        Result<Object> resource = resourceRepository.findOne(resourceId, queryAdapter).map(JsonApiResponse::getEntity);
        if (Iterable.class.isAssignableFrom(relationshipField.getType())) {
            Iterable dataBodies = requestBody.isMultiple() ? requestBody.getData().get() : Collections.singletonList(requestBody.getData().get());
            result = this.processToManyRelationship(resource, targetInformation, relationshipField, dataBodies, queryAdapter, relationshipRepositoryForClass);
        } else {
            if (requestBody.isMultiple()) {
                throw new RequestBodyException(HttpMethod.POST, resourcePath, "Multiple data in body");
            }
            ResourceIdentifier dataBody = (ResourceIdentifier)requestBody.getData().get();
            result = this.processToOneRelationship(resource, targetInformation, relationshipField, dataBody, queryAdapter, relationshipRepositoryForClass);
        }
        return result.map(it -> new Response(new Document(), 204));
    }

    private Serializable getResourceId(PathIds resourceIds, RegistryEntry registryEntry) {
        String resourceId = resourceIds.getIds().get(0);
        Class<?> idClass = registryEntry.getResourceInformation().getIdField().getType();
        TypeParser typeParser = this.context.getTypeParser();
        return (Serializable)typeParser.parse(resourceId, idClass);
    }
}

