/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.controller.BaseController;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathIds;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.ArrayList;

public class ResourceDelete
extends BaseController {
    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.DELETE.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestBody) {
        String resourcePath = jsonPath.getElementName();
        PathIds resourceIds = jsonPath.getIds();
        RegistryEntry registryEntry = this.getRegistryEntryByPath(resourcePath);
        if (registryEntry == null) {
            throw new ResourceNotFoundException(resourcePath);
        }
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        this.logger.debug("deleting ids={}", (Object)resourceIds);
        ArrayList results = new ArrayList();
        for (String id : resourceIds.getIds()) {
            Serializable castedId = registryEntry.getResourceInformation().parseIdString(id);
            ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
            Result<JsonApiResponse> result = resourceRepository.delete(castedId, queryAdapter);
            results.add(result);
        }
        ResultFactory resultFactory = this.context.getResultFactory();
        Response response = new Response(null, 204);
        if (results.isEmpty()) {
            return resultFactory.just(response);
        }
        return resultFactory.zip(results).map(it -> {
            this.logger.debug("set response {}", it);
            return response;
        });
    }
}

