/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ResourcePatch
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.PATCH;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.PATCH.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document requestDocument) {
        RegistryEntry endpointRegistryEntry = this.getRegistryEntry(jsonPath);
        Resource requestResource = this.getRequestBody(requestDocument, jsonPath, HttpMethod.PATCH);
        RegistryEntry registryEntry = this.context.getResourceRegistry().getEntry(requestResource.getType());
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        String idString = jsonPath.getIds().getIds().get(0);
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        Serializable resourceId = resourceInformation.parseIdString(idString);
        this.verifyTypes(HttpMethod.PATCH, endpointRegistryEntry, registryEntry);
        DocumentMappingConfig mappingConfig = DocumentMappingConfig.create().setParameterProvider(parameterProvider);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository(parameterProvider);
        return resourceRepository.findOne(resourceId, queryAdapter).merge(existingResponse -> {
            Object existingEntity = existingResponse.getEntity();
            this.checkNotNull(existingEntity, jsonPath);
            resourceInformation.verify(existingEntity, requestDocument);
            return documentMapper.toDocument((JsonApiResponse)existingResponse, queryAdapter, mappingConfig).map(it -> it.getSingleData().get()).doWork(existing -> this.mergeNestedAttribute((Resource)existing, requestResource)).map(it -> existingEntity);
        }).merge(existingEntity -> this.applyChanges(registryEntry, existingEntity, requestResource, queryAdapter, parameterProvider)).map(this::toResponse);
    }

    private Response toResponse(Document updatedDocument) {
        return new Response(updatedDocument, 200);
    }

    private Result<Document> applyChanges(RegistryEntry registryEntry, Object existingResource, Resource requestResource, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Result<JsonApiResponse> updatedResource;
        Set<String> loadedRelationshipNames;
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository(parameterProvider);
        if (resourceInformation.getResourceClass() == Resource.class) {
            loadedRelationshipNames = this.getLoadedRelationshipNames(requestResource);
            updatedResource = resourceRepository.update(requestResource, queryAdapter);
        } else {
            QueryContext queryContext = queryAdapter.getQueryContext();
            this.setAttributes(requestResource, existingResource, resourceInformation, queryContext);
            loadedRelationshipNames = this.getLoadedRelationshipNames(requestResource);
            Result<List> relationsResult = this.setRelationsAsync(existingResource, registryEntry, requestResource, queryAdapter, parameterProvider, false);
            updatedResource = relationsResult.merge(it -> resourceRepository.update(existingResource, queryAdapter));
        }
        DocumentMappingConfig mappingConfig = DocumentMappingConfig.create().setParameterProvider(parameterProvider).setFieldsWithEnforcedIdSerialization(loadedRelationshipNames);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        return updatedResource.doWork(it -> this.logger.debug("patched resource {}", it)).merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig));
    }

    private void mergeNestedAttribute(final Resource existingReseource, final Resource requestResource) {
        ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ObjectMapper objectMapper = ResourcePatch.this.context.getObjectMapper();
                String attributesFromFindOne = ResourcePatch.this.extractAttributesFromResourceAsJson(existingReseource);
                HashMap attributesToUpdate = new HashMap(ResourcePatch.this.emptyIfNull((Map)objectMapper.readValue(attributesFromFindOne, Map.class)));
                String attributesAsJson = objectMapper.writeValueAsString(requestResource.getAttributes());
                Map attributesFromRequest = ResourcePatch.this.emptyIfNull((Map)objectMapper.readValue(attributesAsJson, Map.class));
                Iterator it = attributesToUpdate.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (attributesFromRequest.containsKey(key)) continue;
                    it.remove();
                }
                ResourcePatch.this.updateValues(attributesToUpdate, attributesFromRequest);
                HashMap<String, JsonNode> upsertedAttributes = new HashMap<String, JsonNode>();
                for (Map.Entry entry : attributesToUpdate.entrySet()) {
                    JsonNode value = objectMapper.valueToTree(entry.getValue());
                    upsertedAttributes.put((String)entry.getKey(), value);
                }
                requestResource.setAttributes(upsertedAttributes);
                return null;
            }
        }, "failed to merge patched attributes", new Object[0]);
    }

    private void checkNotNull(Object resource, JsonPath jsonPath) {
        if (resource == null) {
            throw new ResourceNotFoundException(jsonPath.toString());
        }
    }

    private <K, V> Map<K, V> emptyIfNull(Map<K, V> value) {
        return value != null ? value : Collections.emptyMap();
    }

    private String extractAttributesFromResourceAsJson(Resource resource) throws IOException {
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ObjectMapper objectMapper = this.context.getObjectMapper();
        String newRequestBody = objectMapper.writeValueAsString((Object)resource);
        JsonNode node = objectMapper.readTree(newRequestBody);
        JsonNode attributes = node.findValue("attributes");
        return objectMapper.writeValueAsString((Object)attributes);
    }

    private void updateValues(Map<String, Object> source, Map<String, Object> updates) {
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            String fieldName = entry.getKey();
            Object updatedValue = entry.getValue();
            if (updatedValue instanceof Map) {
                if (source.get(fieldName) == null) {
                    source.put(fieldName, new HashMap());
                }
                Object sourceMap = source.get(fieldName);
                this.updateValues((Map)sourceMap, (Map)updatedValue);
                continue;
            }
            source.put(fieldName, updatedValue);
        }
    }
}

