/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.filter.ResourceRelationshipModificationType;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.AnyResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.properties.ResourceFieldImmutableWriteBehavior;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.exception.ForbiddenException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class ResourceUpsert
extends ResourceIncludeField {
    protected Resource getRequestBody(Document requestDocument, JsonPath path, HttpMethod method) {
        String resourceType = path.getResourcePath();
        this.assertRequestDocument(requestDocument, method, resourceType);
        if (!requestDocument.getData().isPresent() || requestDocument.getData().get() == null) {
            throw new RequestBodyException(method, resourceType, "No data field in the body.");
        }
        if (requestDocument.getData().get() instanceof Collection) {
            throw new RequestBodyException(method, resourceType, "Multiple data in body");
        }
        Resource resourceBody = (Resource)requestDocument.getData().get();
        RegistryEntry bodyRegistryEntry = this.context.getResourceRegistry().getEntry(resourceBody.getType());
        if (bodyRegistryEntry == null) {
            throw new RepositoryNotFoundException(resourceBody.getType());
        }
        return resourceBody;
    }

    protected RegistryEntry getRegistryEntry(JsonPath jsonPath) {
        String resourcePath = jsonPath.getResourcePath();
        return this.getRegistryEntryByPath(resourcePath);
    }

    protected Object newResource(ResourceInformation resourceInformation, Resource dataBody) {
        ResourceInstanceBuilder builder = resourceInformation.getInstanceBuilder();
        return builder.buildResource(dataBody);
    }

    protected void setId(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        if (dataBody.getId() != null) {
            String id = dataBody.getId();
            Serializable castedId = resourceInformation.parseIdString(id);
            ResourceField idField = resourceInformation.getIdField();
            idField.getAccessor().setValue(instance, castedId);
        }
    }

    protected Set<String> getLoadedRelationshipNames(Resource resourceBody) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Relationship> entry : resourceBody.getRelationships().entrySet()) {
            if (entry.getValue() == null || entry.getValue().getData() == null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected void setAttributes(Resource dataBody, Object instance, ResourceInformation resourceInformation, QueryContext queryContext) {
        if (dataBody.getAttributes() != null) {
            for (Map.Entry<String, JsonNode> entry : dataBody.getAttributes().entrySet()) {
                String attributeName = entry.getKey();
                this.setAttribute(resourceInformation, instance, attributeName, entry.getValue(), queryContext);
            }
        }
    }

    private void setAttribute(ResourceInformation resourceInformation, Object instance, String attributeName, JsonNode valueNode, QueryContext queryContext) {
        ResourceField field = resourceInformation.findAttributeFieldByName(attributeName);
        if (this.canModifyField(resourceInformation, attributeName, field, queryContext)) {
            this.logger.debug("set field {}={}", (Object)attributeName, (Object)valueNode);
            ObjectMapper objectMapper = this.context.getObjectMapper();
            List<ResourceModificationFilter> modificationFilters = this.context.getModificationFilters();
            try {
                if (field != null) {
                    Object value;
                    Type valueType = field.getGenericType();
                    if (valueNode != null) {
                        JavaType jacksonValueType = objectMapper.getTypeFactory().constructType(valueType);
                        ObjectReader reader = objectMapper.reader().forType(jacksonValueType);
                        value = reader.readValue(valueNode);
                    } else {
                        value = null;
                    }
                    for (ResourceModificationFilter filter : modificationFilters) {
                        value = filter.modifyAttribute(instance, field, attributeName, value);
                    }
                    field.getAccessor().setValue(instance, value);
                } else if (resourceInformation.getAnyFieldAccessor() != null) {
                    AnyResourceFieldAccessor anyFieldAccessor = resourceInformation.getAnyFieldAccessor();
                    Object value = objectMapper.reader().forType(Object.class).readValue(valueNode);
                    for (ResourceModificationFilter filter : modificationFilters) {
                        value = filter.modifyAttribute(instance, field, attributeName, value);
                    }
                    anyFieldAccessor.setValue(instance, attributeName, value);
                }
            }
            catch (IOException e) {
                throw new ResourceException(String.format("Exception while setting %s.%s=%s due to %s", instance, attributeName, valueNode, e.getMessage()), e);
            }
        }
    }

    protected boolean canModifyField(ResourceInformation resourceInformation, String fieldName, ResourceField field, QueryContext queryContext) {
        if (field == null) {
            return true;
        }
        HttpMethod method = this.getHttpMethod();
        ResourceFieldAccess access = field.getAccess();
        boolean modifiable = method == HttpMethod.POST ? access.isPostable() : access.isPatchable();
        FilterBehavior filterBehavior = modifiable ? FilterBehavior.NONE : this.getDefaultFilterBehavior();
        ResourceFilterDirectory resourceFilterDirectory = this.context.getResourceFilterDirectory();
        if ((filterBehavior = filterBehavior.merge(resourceFilterDirectory.get(field, method, queryContext))) == FilterBehavior.NONE) {
            return true;
        }
        if (filterBehavior == FilterBehavior.FORBIDDEN) {
            throw new ForbiddenException("field '" + fieldName + "' cannot be modified");
        }
        this.logger.debug("ignoring field {}", (Object)field.getUnderlyingName());
        PreconditionUtil.assertEquals("unknown behavior", (Object)FilterBehavior.IGNORED, (Object)filterBehavior);
        return false;
    }

    public FilterBehavior getDefaultFilterBehavior() {
        PropertiesProvider propertiesProvider = this.context.getPropertiesProvider();
        String strBehavior = propertiesProvider.getProperty("crnk.config.resource.immutableWrite");
        ResourceFieldImmutableWriteBehavior behavior = strBehavior != null ? ResourceFieldImmutableWriteBehavior.valueOf(strBehavior) : ResourceFieldImmutableWriteBehavior.IGNORE;
        return behavior == ResourceFieldImmutableWriteBehavior.IGNORE ? FilterBehavior.IGNORED : FilterBehavior.FORBIDDEN;
    }

    protected abstract HttpMethod getHttpMethod();

    Object buildNewResource(RegistryEntry registryEntry, Resource dataBody, String resourceName) {
        PreconditionUtil.verify(dataBody != null, "No data field in the body.", new Object[0]);
        PreconditionUtil.verify(resourceName.equals(dataBody.getType()), "Inconsistent type definition between path and body: body type: %s, request type: %s", dataBody.getType(), resourceName);
        Class<?> resourceClass = registryEntry.getResourceInformation().getResourceClass();
        return ClassUtils.newInstance(resourceClass);
    }

    protected Result<List> setRelationsAsync(Object newResource, RegistryEntry registryEntry, Resource resource, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, boolean ignoreMissing) {
        ArrayList results = new ArrayList();
        if (resource.getRelationships() != null) {
            for (Map.Entry<String, Relationship> entry : resource.getRelationships().entrySet()) {
                ResourceInformation resourceInformation;
                ResourceField field;
                String relationshipName = entry.getKey();
                Relationship relationship = entry.getValue();
                if (relationship == null || (field = (resourceInformation = registryEntry.getResourceInformation()).findRelationshipFieldByName(relationshipName)) == null && ignoreMissing) continue;
                if (field == null) {
                    throw new ResourceException(String.format("Invalid relationship name: %s for %s", entry.getKey(), resourceInformation.getResourceType()));
                }
                Optional<Result> result = field.isCollection() ? this.setRelationsFieldAsync(newResource, registryEntry, entry, queryAdapter, parameterProvider) : this.setRelationFieldAsync(newResource, registryEntry, relationshipName, relationship, queryAdapter, parameterProvider);
                if (!result.isPresent()) continue;
                results.add(result.get());
            }
        }
        ResultFactory resultFactory = this.context.getResultFactory();
        return resultFactory.zip(results);
    }

    protected Optional<Result> setRelationsFieldAsync(Object newResource, RegistryEntry registryEntry, Map.Entry<String, Relationship> property, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Relationship relationship = property.getValue();
        if (relationship.getData().isPresent()) {
            String propertyName = property.getKey();
            ResourceField relationshipField = registryEntry.getResourceInformation().findRelationshipFieldByName(propertyName);
            List<ResourceIdentifier> relationshipIds = relationship.getCollectionData().get();
            List<ResourceModificationFilter> modificationFilters = this.context.getModificationFilters();
            for (ResourceModificationFilter filter : modificationFilters) {
                relationshipIds = filter.modifyManyRelationship(newResource, relationshipField, ResourceRelationshipModificationType.SET, relationshipIds);
            }
            ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
            LinkedList<Serializable> relationshipTypedIds = new LinkedList<Serializable>();
            for (ResourceIdentifier resourceId : relationshipIds) {
                RegistryEntry entry = this.getRegistryEntry(resourceId.getType());
                Class<?> idFieldType = entry.getResourceInformation().getIdField().getType();
                Serializable typedRelationshipId = this.parseId(resourceId, idFieldType);
                relationshipTypedIds.add(typedRelationshipId);
            }
            if (relationshipField.hasIdField()) {
                relationshipField.getIdAccessor().setValue(newResource, relationshipTypedIds);
            }
            if (this.decideSetRelationObjectsField(relationshipField)) {
                ArrayList relatedResults = new ArrayList();
                for (int i = 0; i < relationshipIds.size(); ++i) {
                    ResourceIdentifier resourceId = relationshipIds.get(i);
                    Serializable typedRelationshipId = (Serializable)relationshipTypedIds.get(i);
                    RegistryEntry entry = resourceRegistry.getEntry(resourceId.getType());
                    relatedResults.add(this.fetchRelated(entry, typedRelationshipId, parameterProvider, queryAdapter));
                }
                if (relatedResults.isEmpty()) {
                    LinkedList relatedList = new LinkedList();
                    relationshipField.getAccessor().setValue(newResource, relatedList);
                } else {
                    return Optional.of(this.context.getResultFactory().zip(relatedResults).doWork(relatedObjects -> {
                        LinkedList relatedList = new LinkedList();
                        relatedList.addAll(relatedObjects);
                        relationshipField.getAccessor().setValue(newResource, relatedList);
                    }));
                }
            }
        }
        return Optional.empty();
    }

    protected boolean decideSetRelationObjectsField(ResourceField relationshipField) {
        return !relationshipField.hasIdField();
    }

    protected Optional<Result> setRelationFieldAsync(Object newResource, RegistryEntry registryEntry, String relationshipName, Relationship relationship, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        if (relationship.getData().isPresent()) {
            ResourceIdentifier relationshipId = (ResourceIdentifier)relationship.getData().get();
            ResourceField field = registryEntry.getResourceInformation().findRelationshipFieldByName(relationshipName);
            if (field == null) {
                throw new ResourceException(String.format("Invalid relationship name: %s", relationshipName));
            }
            List<ResourceModificationFilter> modificationFilters = this.context.getModificationFilters();
            for (ResourceModificationFilter filter : modificationFilters) {
                relationshipId = filter.modifyOneRelationship(newResource, field, relationshipId);
            }
            if (relationshipId == null) {
                field.getAccessor().setValue(newResource, null);
            } else {
                RegistryEntry entry = this.getRegistryEntry(relationshipId.getType());
                Class<?> idFieldType = entry.getResourceInformation().getIdField().getType();
                Serializable typedRelationshipId = this.parseId(relationshipId, idFieldType);
                if (field.hasIdField()) {
                    field.getIdAccessor().setValue(newResource, typedRelationshipId);
                }
                if (this.decideSetRelationObjectField(entry, typedRelationshipId, field)) {
                    Result<Object> result = this.fetchRelated(entry, typedRelationshipId, parameterProvider, queryAdapter).doWork(relatedObject -> field.getAccessor().setValue(newResource, relatedObject));
                    return Optional.of(result);
                }
            }
        }
        return Optional.empty();
    }

    protected Serializable parseId(ResourceIdentifier relationshipId, Class idFieldType) {
        TypeParser typeParser = this.context.getTypeParser();
        return (Serializable)typeParser.parse(relationshipId.getId(), idFieldType);
    }

    protected boolean decideSetRelationObjectField(RegistryEntry entry, Serializable relationId, ResourceField field) {
        return !field.hasIdField();
    }

    protected Result<Object> fetchRelated(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        return entry.getResourceRepository(parameterProvider).findOne(relationId, queryAdapter).map(JsonApiResponse::getEntity);
    }
}

