/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class IncludePopulatedCache {
    private final ResourceRegistry resourceRegistry;
    private HashSet<String> processed = new HashSet();

    public IncludePopulatedCache(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public void markProcessed(Resource resource, ResourceField field) {
        String key = this.getKey(resource, field);
        this.processed.add(key);
    }

    public Collection<Resource> filterProcessed(Collection<Resource> resources, ResourceField field) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (this.wasProcessed(resource, field)) continue;
            result.add(resource);
            this.markProcessed(resource, field);
        }
        return result;
    }

    public boolean wasProcessed(Resource resource, ResourceField field) {
        String key = this.getKey(resource, field);
        return this.processed.contains(key);
    }

    private String getKey(Resource resource, ResourceField field) {
        return this.resourceRegistry.getBaseResourceInformation(resource.getType()).getResourceType() + "@" + resource.getId() + "@" + field.getUnderlyingName();
    }
}

