/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutExceptionMapper
implements ExceptionMapper<TimeoutException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutExceptionMapper.class);

    @Override
    public ErrorResponse toErrorResponse(TimeoutException exception) {
        LOGGER.error("failed with timeout", (Throwable)exception);
        return ErrorResponse.builder().setStatus(504).build();
    }

    @Override
    public TimeoutException fromErrorResponse(ErrorResponse errorResponse) {
        return new TimeoutException();
    }

    @Override
    public boolean accepts(ErrorResponse errorResponse) {
        int httpStatus = errorResponse.getHttpStatus();
        return httpStatus == 504;
    }
}

