/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class HttpRequestContextBaseAdapter
implements HttpRequestContext {
    private HttpRequestContextBase base;
    private boolean hasResponse;
    private Map<String, Object> requestAttributes = new ConcurrentHashMap<String, Object>();
    private QueryContext queryContext = new QueryContext();

    public HttpRequestContextBaseAdapter(HttpRequestContextBase base) {
        this.base = base;
        this.queryContext.setBaseUrl(base.getBaseUrl());
        this.queryContext.setAttributes(this.requestAttributes);
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    @Override
    public boolean accepts(String contentType) {
        String accept = this.getRequestHeader("Accept");
        if (accept == null) {
            return false;
        }
        for (String acceptElement : accept.split("\\,")) {
            if (!this.isCompatible(acceptElement = acceptElement.trim(), contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setContentType(String contentType) {
        this.base.setResponseHeader("Content-Type", contentType);
    }

    @Override
    public void setResponse(final int statusCode, final String text) {
        this.hasResponse = true;
        ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String charSet = "utf-8";
                byte[] bytes = text.getBytes(charSet);
                HttpRequestContextBaseAdapter.this.base.setResponse(statusCode, bytes);
                return null;
            }
        });
    }

    @Override
    public boolean acceptsAny() {
        String accept = this.getRequestHeader("Accept");
        return accept == null || this.accepts("*") || this.accepts("*/*");
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        if (type.isInstance(this.base)) {
            return (T)this.base;
        }
        return null;
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.requestAttributes.get(name);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.requestAttributes.put(name, value);
    }

    @Override
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    protected boolean isCompatible(String accept, String contentType) {
        String acceptLower = accept.toLowerCase();
        if (accept.equals(contentType)) {
            return true;
        }
        if (acceptLower.startsWith(contentType) && acceptLower.length() > contentType.length()) {
            char c = acceptLower.charAt(contentType.length());
            return c == ' ' || c == ';';
        }
        return false;
    }

    @Override
    public RepositoryMethodParameterProvider getRequestParameterProvider() {
        return this.base.getRequestParameterProvider();
    }

    @Override
    public String getRequestHeader(String name) {
        return this.base.getRequestHeader(name);
    }

    @Override
    public Map<String, Set<String>> getRequestParameters() {
        return this.base.getRequestParameters();
    }

    @Override
    public String getPath() {
        return this.base.getPath();
    }

    @Override
    public String getBaseUrl() {
        return this.base.getBaseUrl();
    }

    @Override
    public byte[] getRequestBody() {
        return this.base.getRequestBody();
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.base.setResponseHeader(name, value);
    }

    @Override
    public void setResponse(int code, byte[] body) throws IOException {
        this.hasResponse = true;
        this.base.setResponse(code, body);
    }

    @Override
    public String getMethod() {
        return this.base.getMethod();
    }

    @Override
    public String getResponseHeader(String name) {
        return this.base.getResponseHeader(name);
    }

    @Override
    public HttpResponse getResponse() {
        return this.base.getResponse();
    }

    @Override
    public void setResponse(HttpResponse response) {
        this.base.setResponse(response);
    }
}

