/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.ResourceRepositoryFacade;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapterImpl;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapterImpl;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.legacy.registry.AnnotatedRelationshipEntryBuilder;
import io.crnk.legacy.registry.AnnotatedResourceEntry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LegacyRegistryEntry
implements RegistryEntry {
    @Deprecated
    private ResourceEntry resourceEntry;
    @Deprecated
    private Map<ResourceField, ResponseRelationshipEntry> relationshipEntries;
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;

    @Deprecated
    public LegacyRegistryEntry(ResourceEntry resourceEntry) {
        this(resourceEntry, new HashMap<ResourceField, ResponseRelationshipEntry>());
    }

    @Deprecated
    public LegacyRegistryEntry(ResourceEntry resourceEntry, Map<ResourceField, ResponseRelationshipEntry> relationshipEntries) {
        this.resourceEntry = resourceEntry;
        this.relationshipEntries = relationshipEntries;
    }

    public void initialize(ModuleRegistry moduleRegistry) {
        PreconditionUtil.assertNotNull("no moduleRegistry", moduleRegistry);
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public ResourceRepositoryAdapter getResourceRepository(RepositoryMethodParameterProvider parameterProvider) {
        Object repoInstance = null;
        if (this.resourceEntry instanceof DirectResponseResourceEntry) {
            repoInstance = ((DirectResponseResourceEntry)this.resourceEntry).getResourceRepository();
        } else if (this.resourceEntry instanceof AnnotatedResourceEntry) {
            repoInstance = ((AnnotatedResourceEntry)this.resourceEntry).build(parameterProvider);
        }
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        ResourceRepositoryInformation information = this.getRepositoryInformation();
        return new ResourceRepositoryAdapterImpl(information, this.moduleRegistry, repoInstance);
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(String fieldName, RepositoryMethodParameterProvider parameterProvider) {
        ResourceField field = this.getResourceInformation().findFieldByUnderlyingName(fieldName);
        if (field == null) {
            throw new ResourceFieldNotFoundException("field=" + fieldName);
        }
        return this.getRelationshipRepository(field, parameterProvider);
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(ResourceField field, RepositoryMethodParameterProvider parameterProvider) {
        ResponseRelationshipEntry relationshipEntry = this.relationshipEntries.get(field);
        if (relationshipEntry == null) {
            throw new RelationshipRepositoryNotFoundException(this.getResourceInformation().getResourceType(), field.getUnderlyingName());
        }
        Object repoInstance = relationshipEntry instanceof AnnotatedRelationshipEntryBuilder ? ((AnnotatedRelationshipEntryBuilder)relationshipEntry).build(parameterProvider) : ((DirectResponseRelationshipEntry)relationshipEntry).getRepositoryInstanceBuilder();
        if (repoInstance instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repoInstance).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return new RelationshipRepositoryAdapterImpl(field, this.moduleRegistry, repoInstance);
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceEntry.getRepositoryInformation().getResourceInformation().get();
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.resourceEntry.getRepositoryInformation();
    }

    @Override
    public RegistryEntry getParentRegistryEntry() {
        ResourceInformation resourceInformation = this.getResourceInformation();
        String superResourceType = resourceInformation.getSuperResourceType();
        if (superResourceType != null) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Override
    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    @Override
    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry entry = this.getParentRegistryEntry(); entry != null; entry = entry.getParentRegistryEntry()) {
            if (!entry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public ResourceRepositoryAdapter getResourceRepository() {
        return this.getResourceRepository(null);
    }

    @Override
    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getResourceRepositoryFacade() {
        return new ResourceRepositoryFacade(this, this.moduleRegistry);
    }

    public Map<ResourceField, ResponseRelationshipEntry> getRelationshipEntries() {
        return this.relationshipEntries;
    }
}

