/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.ResourceRepositoryFacade;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryEntryImpl
implements RegistryEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryEntryImpl.class);
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;
    private ResourceRepositoryAdapter resourceRepositoryAdapter;
    private Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapter;

    public RegistryEntryImpl(ResourceRepositoryAdapter resourceRepositoryAdapter, Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapters, ModuleRegistry moduleRegistry) {
        this.resourceRepositoryAdapter = resourceRepositoryAdapter;
        this.relationshipRepositoryAdapter = relationshipRepositoryAdapters;
        this.moduleRegistry = moduleRegistry;
        PreconditionUtil.assertNotNull("no moduleRegistry", moduleRegistry);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.getResourceInformation().getResourceType() + "]";
    }

    @Override
    public ResourceRepositoryAdapter getResourceRepository(RepositoryMethodParameterProvider parameterProvider) {
        return this.resourceRepositoryAdapter;
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(String fieldName, RepositoryMethodParameterProvider parameterProvider) {
        ResourceField field = this.getResourceInformation().findFieldByUnderlyingName(fieldName);
        if (field == null) {
            throw new ResourceFieldNotFoundException("field=" + fieldName);
        }
        return this.getRelationshipRepository(field, parameterProvider);
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(ResourceField field, RepositoryMethodParameterProvider parameterProvider) {
        RelationshipRepositoryAdapter adapter = this.relationshipRepositoryAdapter.get(field);
        if (adapter == null) {
            throw new RelationshipRepositoryNotFoundException(this.getResourceInformation().getResourceType(), field.getUnderlyingName());
        }
        return adapter;
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceRepositoryAdapter.getRepositoryInformation().getResourceInformation().get();
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.resourceRepositoryAdapter.getRepositoryInformation();
    }

    @Override
    public RegistryEntry getParentRegistryEntry() {
        ResourceInformation resourceInformation = this.getResourceInformation();
        String superResourceType = resourceInformation.getSuperResourceType();
        if (superResourceType != null) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Override
    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    @Override
    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry entry = this.getParentRegistryEntry(); entry != null; entry = entry.getParentRegistryEntry()) {
            if (!entry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public ResourceRepositoryAdapter getResourceRepository() {
        return this.getResourceRepository(null);
    }

    @Override
    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getResourceRepositoryFacade() {
        return new ResourceRepositoryFacade(this, this.moduleRegistry);
    }
}

