/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.mapper;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.QuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpecDeserializerContext;
import io.crnk.core.queryspec.QuerySpecSerializer;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.internal.DefaultQueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryParameter;
import io.crnk.core.queryspec.mapper.QueryParameterType;
import io.crnk.core.queryspec.mapper.QueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryPathSpec;
import io.crnk.core.queryspec.mapper.QuerySpecUrlContext;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UnkonwnMappingAware;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQuerySpecUrlMapper
implements QuerySpecUrlMapper,
QuerySpecDeserializer,
QuerySpecSerializer,
UnkonwnMappingAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQuerySpecUrlMapper.class);
    private FilterOperator defaultOperator = FilterOperator.EQ;
    private Set<FilterOperator> supportedOperators = new HashSet<FilterOperator>();
    private boolean enforceDotPathSeparator = false;
    private boolean ignoreParseExceptions;
    private boolean allowUnknownParameters = false;
    protected QuerySpecUrlContext context;
    protected QueryPathResolver pathResolver = new DefaultQueryPathResolver();

    public DefaultQuerySpecUrlMapper() {
        this.supportedOperators.add(FilterOperator.LIKE);
        this.supportedOperators.add(FilterOperator.EQ);
        this.supportedOperators.add(FilterOperator.NEQ);
        this.supportedOperators.add(FilterOperator.GT);
        this.supportedOperators.add(FilterOperator.GE);
        this.supportedOperators.add(FilterOperator.LT);
        this.supportedOperators.add(FilterOperator.LE);
    }

    @Override
    public void init(QuerySpecUrlContext ctx) {
        this.context = ctx;
        this.pathResolver.init(this.context);
    }

    public boolean getEnforceDotPathSeparator() {
        return this.enforceDotPathSeparator;
    }

    public void setEnforceDotPathSeparator(boolean enforceDotPathSeparator) {
        this.enforceDotPathSeparator = enforceDotPathSeparator;
    }

    @Override
    public boolean getAllowUnknownAttributes() {
        return this.pathResolver.getAllowUnknownAttributes();
    }

    @Override
    public void setAllowUnknownAttributes(boolean allowUnknownAttributes) {
        this.pathResolver.setAllowUnknownAttributes(allowUnknownAttributes);
    }

    public boolean getMapJsonNames() {
        return this.pathResolver.getMapJsonNames();
    }

    public void setMapJsonNames(boolean mapJsonNames) {
        this.pathResolver.setMapJsonNames(mapJsonNames);
    }

    public FilterOperator getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(FilterOperator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public Set<FilterOperator> getSupportedOperators() {
        return this.supportedOperators;
    }

    public void addSupportedOperator(FilterOperator supportedOperator) {
        this.supportedOperators.add(supportedOperator);
    }

    protected QuerySpec createQuerySpec(ResourceInformation resourceInformation) {
        return new QuerySpec(resourceInformation);
    }

    @Override
    public void init(final QuerySpecDeserializerContext ctx) {
        this.init(new QuerySpecUrlContext(){

            @Override
            public ResourceRegistry getResourceRegistry() {
                return ctx.getResourceRegistry();
            }

            @Override
            public TypeParser getTypeParser() {
                return ctx.getTypeParser();
            }
        });
    }

    @Override
    public QuerySpec deserialize(ResourceInformation resourceInformation, Map<String, Set<String>> parameterMap) {
        QuerySpec rootQuerySpec = this.createQuerySpec(resourceInformation);
        List<QueryParameter> parameters = this.parseParameters(parameterMap, resourceInformation);
        HashMap<String, Set<String>> pageParameters = new HashMap<String, Set<String>>();
        block7: for (QueryParameter parameter : parameters) {
            QuerySpec querySpec = rootQuerySpec;
            if (parameter.getResourceInformation() != null && (querySpec = rootQuerySpec.getQuerySpec(parameter.getResourceInformation())) == null) {
                querySpec = rootQuerySpec.getOrCreateQuerySpec(parameter.getResourceInformation());
            }
            switch (parameter.getType()) {
                case SORT: {
                    this.deserializeSort(querySpec, parameter);
                    continue block7;
                }
                case FILTER: {
                    this.deserializeFilter(querySpec, parameter);
                    continue block7;
                }
                case INCLUDE: {
                    this.deserializeIncludes(querySpec, parameter);
                    continue block7;
                }
                case FIELDS: {
                    this.deserializeFields(querySpec, parameter);
                    continue block7;
                }
                case PAGE: {
                    pageParameters.put(parameter.getPagingType(), parameter.getValues());
                    continue block7;
                }
            }
            this.deserializeUnknown(querySpec, parameter);
        }
        if (resourceInformation.getPagingBehavior() == null && !pageParameters.isEmpty()) {
            throw new IllegalStateException("Instance of PagingBehavior must be provided");
        }
        if (resourceInformation.getPagingBehavior() != null) {
            rootQuerySpec.setPagingSpec((PagingSpec)resourceInformation.getPagingBehavior().deserialize(pageParameters));
        }
        return rootQuerySpec;
    }

    private static void put(Map<String, Set<String>> map, String key, String value) {
        map.put(key, new HashSet<String>(Arrays.asList(value)));
    }

    private String toJsonPath(ResourceInformation resourceInformation, List<String> attributePath) {
        QueryPathSpec pathSpec = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JAVA, null);
        return StringUtils.join(".", pathSpec.getAttributePath());
    }

    protected String addResourceType(QueryParameterType type, String key, ResourceInformation resourceInformation) {
        String resourceType = resourceInformation.getResourceType();
        return type.toString().toLowerCase() + "[" + resourceType + "]" + (key != null ? key : "");
    }

    private static String serializeValue(Object value) {
        return value.toString();
    }

    @Override
    public Map<String, Set<String>> serialize(QuerySpec querySpec) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        this.serialize(querySpec, map, querySpec);
        return map;
    }

    protected void serialize(QuerySpec querySpec, Map<String, Set<String>> map, QuerySpec parentQuerySpec) {
        ResourceInformation resourceInformation;
        RegistryEntry entry;
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        String resourceType = querySpec.getResourceType();
        if (resourceType == null) {
            entry = resourceRegistry.getEntry(querySpec.getResourceClass());
            if (entry == null) {
                throw new RepositoryNotFoundException(querySpec.getResourceClass());
            }
            resourceInformation = entry.getResourceInformation();
        } else {
            entry = resourceRegistry.getEntry(querySpec.getResourceType());
            resourceInformation = entry == null ? null : entry.getResourceInformation();
        }
        this.serializeFilters(querySpec, resourceInformation, map);
        this.serializeSorting(querySpec, resourceInformation, map);
        this.serializeIncludedFields(querySpec, resourceInformation, map);
        this.serializeIncludedRelations(querySpec, resourceInformation, map);
        entry = resourceRegistry.getEntry(parentQuerySpec.getResourceClass());
        if (entry != null && entry.getResourceInformation() != null && entry.getResourceInformation().getPagingBehavior() != null) {
            map.putAll(entry.getResourceInformation().getPagingBehavior().serialize(querySpec.getPagingSpec(), resourceType));
        }
        for (QuerySpec relatedSpec : querySpec.getRelatedSpecs().values()) {
            this.serialize(relatedSpec, map, querySpec);
        }
    }

    protected void serializeFilters(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map) {
        for (FilterSpec filterSpec : querySpec.getFilters()) {
            if (filterSpec.hasExpressions()) {
                throw new UnsupportedOperationException("filter expressions like and and or not yet supported");
            }
            String attrKey = "[" + this.toJsonPath(resourceInformation, filterSpec.getAttributePath()) + "][" + filterSpec.getOperator().getName() + "]";
            String key = this.addResourceType(QueryParameterType.FILTER, attrKey, resourceInformation);
            if (filterSpec.getValue() instanceof Collection) {
                Collection col = (Collection)filterSpec.getValue();
                HashSet<String> values = new HashSet<String>();
                for (Object elem : col) {
                    values.add(DefaultQuerySpecUrlMapper.serializeValue(elem));
                }
                map.put(key, values);
                continue;
            }
            String value = DefaultQuerySpecUrlMapper.serializeValue(filterSpec.getValue());
            DefaultQuerySpecUrlMapper.put(map, key, value);
        }
    }

    public void serializeSorting(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map) {
        if (!querySpec.getSort().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.SORT, null, resourceInformation);
            StringBuilder builder = new StringBuilder();
            for (SortSpec filterSpec : querySpec.getSort()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                if (filterSpec.getDirection() == Direction.DESC) {
                    builder.append("-");
                }
                builder.append(this.toJsonPath(resourceInformation, filterSpec.getAttributePath()));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void serializeIncludedFields(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map) {
        if (!querySpec.getIncludedFields().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.FIELDS, null, resourceInformation);
            StringBuilder builder = new StringBuilder();
            for (IncludeFieldSpec includedField : querySpec.getIncludedFields()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(this.toJsonPath(resourceInformation, includedField.getAttributePath()));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void serializeIncludedRelations(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map) {
        if (!querySpec.getIncludedRelations().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.INCLUDE, null, resourceInformation);
            StringBuilder builder = new StringBuilder();
            for (IncludeRelationSpec includedField : querySpec.getIncludedRelations()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(this.toJsonPath(resourceInformation, includedField.getAttributePath()));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void deserializeIncludes(QuerySpec querySpec, QueryParameter parameter) {
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                ResourceInformation resourceInformation = parameter.getResourceInformation();
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName());
                querySpec.includeRelation(resolvedPath.getAttributePath());
            }
        }
    }

    private String[] splitValues(String values) {
        return values.split(",");
    }

    protected void deserializeFields(QuerySpec querySpec, QueryParameter parameter) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName());
                querySpec.includeField(resolvedPath.getAttributePath());
            }
        }
    }

    protected void deserializeFilter(QuerySpec querySpec, QueryParameter parameter) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, parameter.getAttributePath(), QueryPathResolver.NamingType.JSON, parameter.getName());
        Class<?> attributeType = ClassUtils.getRawType(resolvedPath.getValueType());
        HashSet<Object> typedValues = new HashSet<Object>();
        for (String stringValue : parameter.getValues()) {
            try {
                if (attributeType != Object.class) {
                    TypeParser typeParser = this.context.getTypeParser();
                    Object value = typeParser.parse(stringValue, attributeType);
                    typedValues.add(value);
                    continue;
                }
                typedValues.add(stringValue);
            }
            catch (ParserException e) {
                if (this.ignoreParseExceptions) {
                    typedValues.add(stringValue);
                    LOGGER.debug("failed to parse {}", (Object)parameter);
                    continue;
                }
                throw new ParametersDeserializationException(parameter.toString(), e);
            }
        }
        HashSet<Object> value = typedValues.size() == 1 ? typedValues.iterator().next() : typedValues;
        querySpec.addFilter(new FilterSpec(resolvedPath.getAttributePath(), parameter.getOperator(), value));
    }

    private void deserializeSort(QuerySpec querySpec, QueryParameter parameter) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                boolean desc = value.startsWith("-");
                if (desc) {
                    value = value.substring(1);
                }
                List<String> attributePath = this.splitAttributePath(value, parameter);
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName());
                Direction dir = desc ? Direction.DESC : Direction.ASC;
                querySpec.addSort(new SortSpec(resolvedPath.getAttributePath(), dir));
            }
        }
    }

    protected void deserializeUnknown(QuerySpec querySpec, QueryParameter parameter) {
        if (!this.allowUnknownParameters) {
            throw new ParametersDeserializationException(parameter.getName());
        }
    }

    protected List<QueryParameter> parseParameters(Map<String, Set<String>> params, ResourceInformation rootResourceInformation) {
        ArrayList<QueryParameter> list = new ArrayList<QueryParameter>();
        Set<Map.Entry<String, Set<String>>> entrySet = params.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            list.add(this.parseParameter(entry.getKey(), entry.getValue(), rootResourceInformation));
        }
        return list;
    }

    protected QueryParameter parseParameter(String parameterName, Set<String> values, ResourceInformation rootResourceInformation) {
        QueryParameterType paramType;
        int typeSep = parameterName.indexOf(91);
        String strParamType = typeSep != -1 ? parameterName.substring(0, typeSep) : parameterName;
        try {
            paramType = QueryParameterType.valueOf(strParamType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            paramType = QueryParameterType.UNKNOWN;
        }
        List<String> elements = this.parseParameterNameArguments(parameterName, typeSep);
        QueryParameter param = new QueryParameter(this.context.getTypeParser());
        param.setName(parameterName);
        param.setType(paramType);
        param.setValues(values);
        if (paramType == QueryParameterType.FILTER && elements.size() >= 1) {
            this.parseFilterParameterName(param, elements, rootResourceInformation);
        } else if (paramType == QueryParameterType.PAGE && elements.size() == 1) {
            param.setResourceInformation(rootResourceInformation);
            param.setPagingType(elements.get(0));
        } else if (paramType == QueryParameterType.PAGE && elements.size() == 2) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), parameterName));
            param.setPagingType(elements.get(1));
        } else if (paramType == QueryParameterType.UNKNOWN) {
            param.setResourceInformation(null);
        } else if (elements.size() == 1) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), parameterName));
        } else {
            param.setResourceInformation(rootResourceInformation);
        }
        if (param.getOperator() == null) {
            param.setOperator(this.defaultOperator);
        }
        return param;
    }

    protected List<String> parseParameterNameArguments(String parameterName, int typeSep) {
        ArrayList<String> elements = new ArrayList<String>();
        if (typeSep != -1) {
            String parameterNameSuffix = parameterName.substring(typeSep);
            if (!parameterNameSuffix.startsWith("[") || !parameterNameSuffix.endsWith("]")) {
                throw new ParametersDeserializationException("expected not [ resp. ] in legacy " + parameterName);
            }
            elements.addAll(Arrays.asList(parameterNameSuffix.substring(1, parameterNameSuffix.length() - 1).split("\\]\\[")));
        }
        return elements;
    }

    protected void parseFilterParameterName(QueryParameter param, List<String> elements, ResourceInformation rootResourceInformation) {
        this.parseFilterOperator(param, elements);
        if (elements.isEmpty()) {
            throw new ParametersDeserializationException("failed to parse " + param.getName() + ", expected ([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() > 2) {
            throw new ParametersDeserializationException("failed to parse " + param.getName() + ", expected ([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() == 2) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), param.getName()));
            param.setAttributePath(Arrays.asList(elements.get(1).split("\\.")));
        } else if (this.enforceDotPathSeparator && elements.size() == 1) {
            param.setResourceInformation(rootResourceInformation);
            param.setAttributePath(Arrays.asList(elements.get(0).split("\\.")));
        } else {
            this.legacyParseFilterParameterName(param, elements, rootResourceInformation);
        }
    }

    protected void legacyParseFilterParameterName(QueryParameter param, List<String> elements, ResourceInformation rootResourceInformation) {
        if (this.isResourceType(elements.get(0))) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), param.getName()));
            elements.remove(0);
        } else {
            param.setResourceInformation(rootResourceInformation);
        }
        ArrayList<String> attributePath = new ArrayList<String>();
        for (String element : elements) {
            attributePath.addAll(Arrays.asList(element.split("\\.")));
        }
        param.setAttributePath(attributePath);
    }

    protected void parseFilterOperator(QueryParameter param, List<String> elements) {
        String lastElement = elements.get(elements.size() - 1);
        FilterOperator operator = this.findOperator(lastElement);
        if (operator != null) {
            elements.remove(elements.size() - 1);
        } else {
            operator = this.defaultOperator;
        }
        param.setOperator(operator);
    }

    protected boolean isResourceType(String resourceType) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        return resourceRegistry.getEntry(resourceType) != null;
    }

    protected FilterOperator findOperator(String lastElement) {
        for (FilterOperator op : this.supportedOperators) {
            if (!op.getName().equalsIgnoreCase(lastElement)) continue;
            return op;
        }
        return null;
    }

    protected ResourceInformation getResourceInformation(String resourceType, String parameterName) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(resourceType);
        if (registryEntry == null) {
            throw new ParametersDeserializationException("failed to parse parameter " + parameterName + ", resourceType=" + resourceType + " not found");
        }
        return registryEntry.getResourceInformation();
    }

    protected List<String> splitAttributePath(String pathString, QueryParameter param) {
        return Arrays.asList(pathString.split("\\."));
    }

    public boolean isIgnoreParseExceptions() {
        return this.ignoreParseExceptions;
    }

    public void setIgnoreParseExceptions(boolean ignoreParseExceptions) {
        this.ignoreParseExceptions = ignoreParseExceptions;
    }

    @Override
    public boolean isAllowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    @Override
    public void setAllowUnknownParameters(boolean allowUnknownParameters) {
        this.allowUnknownParameters = allowUnknownParameters;
    }

    public boolean getAllowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    public QueryPathResolver getPathResolver() {
        return this.pathResolver;
    }
}

