/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.foward.strategy;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.foward.strategy.ForwardingGetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyBase;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GetFromOppositeStrategy<T, I extends Serializable, D, J extends Serializable>
extends ForwardingStrategyBase
implements ForwardingGetStrategy<T, I, D, J> {
    @Override
    public MultivaluedMap<I, D> findTargets(Iterable<I> sourceIds, String fieldName, QuerySpec querySpec, QueryContext queryContext) {
        RegistryEntry sourceEntry = this.context.getSourceEntry();
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        RegistryEntry targetEntry = this.context.getTargetEntry(field);
        ResourceInformation targetInformation = targetEntry.getResourceInformation();
        ResourceField oppositeField = Objects.requireNonNull(targetInformation.findFieldByUnderlyingName(field.getOppositeName()));
        QuerySpec idQuerySpec = querySpec.duplicate();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(oppositeField.getUnderlyingName(), sourceInformation.getIdField().getUnderlyingName()), FilterOperator.EQ, sourceIds));
        idQuerySpec.includeRelation(Arrays.asList(oppositeField.getUnderlyingName()));
        ResourceRepositoryAdapter targetAdapter = targetEntry.getResourceRepository();
        JsonApiResponse response = targetAdapter.findAll(this.context.createQueryAdapter(idQuerySpec, queryContext)).get();
        Collection results = (Collection)response.getEntity();
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        HashSet<Serializable> sourceIdSet = new HashSet<Serializable>();
        for (Serializable sourceId : sourceIds) {
            sourceIdSet.add(sourceId);
        }
        for (Object result : results) {
            this.handleTarget(bulkResult, result, sourceIdSet, oppositeField, sourceInformation);
        }
        return bulkResult;
    }

    private void handleTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, ResourceField oppositeField, ResourceInformation sourceInformation) {
        Object property = oppositeField.getAccessor().getValue(result);
        if (property == null) {
            throw new IllegalStateException("field " + oppositeField.getUnderlyingName() + " is null for " + result + ", make sure to properly implement relationship inclusions");
        }
        if (property instanceof Iterable) {
            for (Object potentialSource : (Iterable)property) {
                Serializable sourceId = (Serializable)sourceInformation.getId(potentialSource);
                if (sourceId == null) {
                    throw new IllegalStateException("id is null for " + potentialSource);
                }
                if (!sourceIdSet.contains(sourceId)) continue;
                bulkResult.add(sourceId, result);
            }
        } else {
            Object source = property;
            Serializable sourceId = (Serializable)sourceInformation.getId(source);
            PreconditionUtil.assertTrue("filtering not properly implemented in resource repository", sourceIdSet.contains(sourceId));
            if (sourceId == null) {
                throw new IllegalStateException("id is null for " + source);
            }
            bulkResult.add(sourceId, result);
        }
    }
}

