/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher;

import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.exception.BadRequestException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerRegistry.class);
    private final List<Controller> controllers = new LinkedList<Controller>();

    public ControllerRegistry(Collection<Controller> controllers) {
        if (controllers != null) {
            this.controllers.addAll(controllers);
        }
    }

    public void addController(Controller controller) {
        this.controllers.add(controller);
    }

    public Controller getController(JsonPath jsonPath, String method) {
        for (Controller controller : this.controllers) {
            if (!controller.isAcceptable(jsonPath, method)) continue;
            LOGGER.debug("using controller {}", (Object)controller);
            return controller;
        }
        throw new BadRequestException(jsonPath + " with method " + method);
    }

    public List<Controller> getControllers() {
        return this.controllers;
    }
}

