/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.filter.ResourceRelationshipModificationType;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldResourcePost
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && FieldPath.class.equals(jsonPath.getClass()) && HttpMethod.POST.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestDocument) {
        FieldPath fieldPath = (FieldPath)jsonPath;
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = jsonPath.getRootEntry();
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        Resource resourceBody = this.getRequestBody(requestDocument, jsonPath, HttpMethod.POST);
        RegistryEntry bodyRegistryEntry = resourceRegistry.getEntry(resourceBody.getType());
        ResourceInformation bodyResourceInformation = bodyRegistryEntry.getResourceInformation();
        Serializable id = jsonPath.getId();
        ResourceField relationshipField = fieldPath.getField();
        RegistryEntry relationshipRegistryEntry = resourceRegistry.getEntry(relationshipField.getOppositeResourceType());
        ResourceInformation relationshipResourceInformation = relationshipRegistryEntry.getResourceInformation();
        ResourceRepositoryAdapter resourceRepository = relationshipRegistryEntry.getResourceRepository();
        String relationshipResourceType = relationshipField.getOppositeResourceType();
        this.verifyTypes(HttpMethod.POST, relationshipRegistryEntry, bodyRegistryEntry);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        QueryContext queryContext = queryAdapter.getQueryContext();
        Object entity = this.buildNewResource(relationshipRegistryEntry, resourceBody, relationshipResourceType);
        this.setId(resourceBody, entity, relationshipResourceInformation);
        this.setType(resourceBody, entity);
        this.setAttributes(resourceBody, entity, relationshipResourceInformation, queryContext);
        this.setMeta(resourceBody, entity, relationshipResourceInformation);
        this.setLinks(resourceBody, entity, relationshipResourceInformation);
        Result createdResource = this.setRelationsAsync(entity, bodyRegistryEntry, resourceBody, queryAdapter, false).merge(it -> resourceRepository.create(entity, queryAdapter));
        DocumentMappingConfig mappingConfig = this.context.getMappingConfig();
        Result<Result> createdDocument = createdResource.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig));
        if (relationshipResourceInformation.isNested()) {
            return createdDocument.map(this::toResponse);
        }
        Result<JsonApiResponse> parentResource = registryEntry.getResourceRepository().findOne(id, queryAdapter);
        return createdDocument.zipWith(parentResource, (created, parent) -> this.attachToParent((JsonApiResponse)parent, registryEntry, relationshipField, (Document)created, queryAdapter)).merge(it -> it).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        int status = this.getStatus(document, HttpMethod.POST);
        Response response = new Response(document, status);
        this.validateCreatedResponse(response);
        return response;
    }

    private Result<Document> attachToParent(JsonApiResponse parent, RegistryEntry endpointRegistryEntry, ResourceField relationshipField, Document createdDocument, QueryAdapter queryAdapter) {
        Result<JsonApiResponse> result;
        ResourceIdentifier resourceId1 = createdDocument.getSingleData().get();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = endpointRegistryEntry.getRelationshipRepository(relationshipField);
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry relationshipRegistryEntry = resourceRegistry.getEntry(relationshipField.getOppositeResourceType());
        List<ResourceModificationFilter> modificationFilters = this.context.getModificationFilters();
        if (Iterable.class.isAssignableFrom(baseRelationshipFieldClass)) {
            List<ResourceIdentifier> resourceIdList = Collections.singletonList(resourceId1);
            for (ResourceModificationFilter filter : modificationFilters) {
                resourceIdList = filter.modifyManyRelationship(parent.getEntity(), relationshipField, ResourceRelationshipModificationType.ADD, resourceIdList);
            }
            ArrayList<Serializable> parsedIds = new ArrayList<Serializable>();
            for (ResourceIdentifier resourceId : resourceIdList) {
                parsedIds.add(relationshipRegistryEntry.getResourceInformation().parseIdString(resourceId.getId()));
            }
            result = relationshipRepositoryForClass.addRelations(parent.getEntity(), parsedIds, relationshipField, queryAdapter);
        } else {
            for (ResourceModificationFilter filter : modificationFilters) {
                resourceId1 = filter.modifyOneRelationship(parent.getEntity(), relationshipField, resourceId1);
            }
            Serializable parseId = relationshipRegistryEntry.getResourceInformation().parseIdString(resourceId1.getId());
            result = relationshipRepositoryForClass.setRelation(parent.getEntity(), parseId, relationshipField, queryAdapter);
        }
        return result.map(it -> createdDocument);
    }
}

