/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.annotations.PatchStrategy;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ResourcePatchController
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.PATCH;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.PATCH.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestDocument) {
        RegistryEntry endpointRegistryEntry = jsonPath.getRootEntry();
        Resource requestResource = this.getRequestBody(requestDocument, jsonPath, HttpMethod.PATCH);
        RegistryEntry registryEntry = this.context.getResourceRegistry().getEntry(requestResource.getType());
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        Serializable resourceId = jsonPath.getId();
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        this.verifyTypes(HttpMethod.PATCH, endpointRegistryEntry, registryEntry);
        DocumentMappingConfig mappingConfig = this.context.getMappingConfig();
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        QueryContext queryContext = queryAdapter.getQueryContext();
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository();
        return resourceRepository.findOne(resourceId, queryAdapter).merge(existingResponse -> {
            Object existingEntity = existingResponse.getEntity();
            this.checkNotNull(existingEntity, jsonPath);
            resourceInformation.verify(existingEntity, requestDocument);
            return documentMapper.toDocument((JsonApiResponse)existingResponse, queryAdapter, mappingConfig).map(it -> it.getSingleData().get()).doWork(existing -> this.mergeNestedAttribute((Resource)existing, requestResource, queryContext, resourceInformation)).map(it -> existingEntity);
        }).merge(existingEntity -> this.applyChanges(registryEntry, existingEntity, requestResource, queryAdapter)).map(this::toResponse);
    }

    private Response toResponse(Document updatedDocument) {
        if (!updatedDocument.getData().isPresent() && (updatedDocument.getErrors() == null || updatedDocument.getErrors().isEmpty())) {
            updatedDocument = null;
        }
        int status = this.getStatus(updatedDocument, HttpMethod.PATCH);
        return new Response(updatedDocument, status);
    }

    private Result<Document> applyChanges(RegistryEntry registryEntry, Object entity, Resource requestResource, QueryAdapter queryAdapter) {
        Result<JsonApiResponse> updatedResource;
        Set<String> loadedRelationshipNames;
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository();
        if (resourceInformation.getImplementationClass() == Resource.class) {
            loadedRelationshipNames = this.getLoadedRelationshipNames(requestResource);
            updatedResource = resourceRepository.update(requestResource, queryAdapter);
        } else {
            QueryContext queryContext = queryAdapter.getQueryContext();
            this.setAttributes(requestResource, entity, resourceInformation, queryContext);
            this.setMeta(requestResource, entity, resourceInformation);
            this.setLinks(requestResource, entity, resourceInformation);
            loadedRelationshipNames = this.getLoadedRelationshipNames(requestResource);
            Result<List> relationsResult = this.setRelationsAsync(entity, registryEntry, requestResource, queryAdapter, false);
            updatedResource = relationsResult.merge(it -> resourceRepository.update(entity, queryAdapter));
        }
        DocumentMappingConfig mappingConfig = this.context.getMappingConfig().clone();
        mappingConfig.setFieldsWithEnforcedIdSerialization(loadedRelationshipNames);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        return updatedResource.doWork(it -> this.logger.debug("patched resource {}", it)).merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig));
    }

    private void mergeNestedAttribute(final Resource existingResource, final Resource requestResource, final QueryContext queryContext, final ResourceInformation resourceInformation) {
        ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ObjectMapper objectMapper = ResourcePatchController.this.context.getObjectMapper();
                String attributesFromFindOne = ResourcePatchController.this.extractAttributesFromResourceAsJson(existingResource);
                HashMap attributesToUpdate = new HashMap(ResourcePatchController.this.emptyIfNull((Map)objectMapper.readValue(attributesFromFindOne, Map.class)));
                String attributesAsJson = objectMapper.writeValueAsString(requestResource.getAttributes());
                Map attributesFromRequest = ResourcePatchController.this.emptyIfNull((Map)objectMapper.readValue(attributesAsJson, Map.class));
                Iterator it = attributesToUpdate.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (attributesFromRequest.containsKey(key)) continue;
                    it.remove();
                }
                ResourcePatchController.this.updateValues(attributesToUpdate, attributesFromRequest, resourceInformation, queryContext, null);
                HashMap<String, JsonNode> upsertedAttributes = new HashMap<String, JsonNode>();
                for (Map.Entry entry : attributesToUpdate.entrySet()) {
                    JsonNode value = objectMapper.valueToTree(entry.getValue());
                    upsertedAttributes.put((String)entry.getKey(), value);
                }
                requestResource.setAttributes(upsertedAttributes);
                return null;
            }
        }, "failed to merge patched attributes", new Object[0]);
    }

    private void checkNotNull(Object resource, JsonPath jsonPath) {
        if (resource == null) {
            throw new ResourceNotFoundException(jsonPath.toString());
        }
    }

    private <K, V> Map<K, V> emptyIfNull(Map<K, V> value) {
        return value != null ? value : Collections.emptyMap();
    }

    private String extractAttributesFromResourceAsJson(Resource resource) throws IOException {
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ObjectMapper objectMapper = this.context.getObjectMapper();
        String newRequestBody = objectMapper.writeValueAsString((Object)resource);
        JsonNode node = objectMapper.readTree(newRequestBody);
        JsonNode attributes = node.findValue("attributes");
        return objectMapper.writeValueAsString((Object)attributes);
    }

    private void updateValues(Map<String, Object> source, Map<String, Object> updates, ResourceInformation resourceInformation, QueryContext queryContext, PatchStrategy patchStrategy) {
        int requestVersion = queryContext.getRequestVersion();
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            String fieldName = entry.getKey();
            Object updatedValue = entry.getValue();
            if (updatedValue instanceof Map) {
                if (patchStrategy == null) {
                    ResourceField field = resourceInformation.findFieldByJsonName(fieldName, requestVersion);
                    PreconditionUtil.verify(field != null, "field %s not found", fieldName);
                    patchStrategy = field.getPatchStrategy();
                }
                if (source.get(fieldName) == null) {
                    source.put(fieldName, new HashMap());
                }
                if (patchStrategy == PatchStrategy.SET) {
                    source.put(fieldName, updatedValue);
                    continue;
                }
                Object sourceMap = source.get(fieldName);
                this.updateValues((Map)sourceMap, (Map)updatedValue, resourceInformation, queryContext, patchStrategy);
                continue;
            }
            source.put(fieldName, updatedValue);
        }
    }
}

