/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.repository.response.JsonApiResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ResourcePostController
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        boolean nestedOne = jsonPath.getParentField() != null && !jsonPath.getParentField().isCollection();
        return (jsonPath.isCollection() || nestedOne) && jsonPath instanceof ResourcePath && HttpMethod.POST.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestDocument) {
        RegistryEntry endpointRegistryEntry = jsonPath.getRootEntry();
        List<Resource> resourceBodies = this.getRequestBodys(requestDocument, jsonPath, HttpMethod.POST);
        ResultFactory resultFactory = this.context.getResultFactory();
        ArrayList entityResults = new ArrayList();
        HashSet<String> loadedRelationshipNames = new HashSet<String>();
        for (Resource resourceBody : resourceBodies) {
            RegistryEntry registryEntry = this.getRegistryEntry(resourceBody.getType());
            this.logger.debug("using registry entry {}", (Object)registryEntry);
            ResourceInformation resourceInformation = registryEntry.getResourceInformation();
            this.verifyTypes(HttpMethod.POST, endpointRegistryEntry, registryEntry);
            loadedRelationshipNames.addAll(this.getLoadedRelationshipNames(resourceBody));
            QueryContext queryContext = queryAdapter.getQueryContext();
            if (Resource.class.equals(resourceInformation.getImplementationClass())) {
                entityResults.add(resultFactory.just(resourceBody));
                continue;
            }
            Object entity = this.newEntity(resourceInformation, resourceBody);
            this.setId(resourceBody, entity, resourceInformation);
            this.setType(resourceBody, entity);
            this.setAttributes(resourceBody, entity, resourceInformation, queryContext);
            this.setMeta(resourceBody, entity, resourceInformation);
            this.setLinks(resourceBody, entity, resourceInformation);
            Result<List> zipped = this.setRelationsAsync(entity, registryEntry, resourceBody, queryAdapter, false);
            entityResults.add(zipped.map(it -> entity));
        }
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository();
        Result<List<List>> result = resultFactory.all(entityResults);
        Result response = result.merge(entities -> resourceRepository.create(this.collectionOrSingleton((List<Object>)entities), queryAdapter));
        DocumentMappingConfig mappingConfig = this.context.getMappingConfig().clone().setFieldsWithEnforcedIdSerialization(loadedRelationshipNames);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        return response.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig)).map(this::toResponse);
    }

    private Object collectionOrSingleton(List<Object> entities) {
        return entities.size() == 1 ? entities.get(0) : entities;
    }

    private Response toResponse(Document responseDocument) {
        int status = this.getStatus(responseDocument, HttpMethod.POST);
        Response response = new Response(responseDocument, status);
        this.validateCreatedResponse(response);
        this.logger.debug("set response {}", (Object)response);
        return response;
    }
}

