/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.mapper.UrlBuilder;
import io.crnk.core.resource.links.Link;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.RelatedLinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.list.LinksContainer;
import io.crnk.core.resource.meta.MetaContainer;
import io.crnk.core.resource.meta.MetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMapperUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentMapper.class);
    private final UrlBuilder urlBuilder;
    private ResourceRegistry resourceRegistry;
    private ObjectMapper objectMapper;
    private static SerializerUtil serializerUtil;

    public DocumentMapperUtil(ResourceRegistry resourceRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider, UrlBuilder urlBuilder) {
        this.urlBuilder = urlBuilder;
        this.resourceRegistry = resourceRegistry;
        this.objectMapper = objectMapper;
        boolean serializeLinksAsObjects = Boolean.parseBoolean(propertiesProvider.getProperty("crnk.config.serialize.object.links"));
        serializerUtil = new SerializerUtil(serializeLinksAsObjects);
    }

    protected static List<ResourceField> getRequestedFields(ResourceInformation resourceInformation, QueryAdapter queryAdapter, List<ResourceField> fields, boolean relation) {
        Set<PathSpec> includedFields;
        Map<String, Set<PathSpec>> includedFieldsSet = queryAdapter != null ? queryAdapter.getIncludedFields() : null;
        Set<PathSpec> set = includedFields = includedFieldsSet != null ? includedFieldsSet.get(resourceInformation.getResourceType()) : null;
        if (DocumentMapperUtil.noResourceIncludedFieldsSpecified(includedFields)) {
            return fields;
        }
        return DocumentMapperUtil.computeRequestedFields(includedFields, relation, queryAdapter, resourceInformation, fields);
    }

    private static List<ResourceField> computeRequestedFields(Set<PathSpec> includedFields, boolean relation, QueryAdapter queryAdapter, ResourceInformation resourceInformation, List<ResourceField> fields) {
        if (relation) {
            Set<PathSpec> includedRelations;
            Map<String, Set<PathSpec>> includedRelationsSet = queryAdapter.getIncludedRelations();
            Set<PathSpec> set = includedRelations = includedRelationsSet != null ? includedRelationsSet.get(resourceInformation.getResourceType()) : null;
            if (includedRelations != null) {
                includedFields = new HashSet<PathSpec>(includedFields);
                for (PathSpec include : includedRelations) {
                    includedFields.add(include);
                }
            }
        }
        ArrayList<ResourceField> results = new ArrayList<ResourceField>();
        for (ResourceField field : fields) {
            if (!DocumentMapperUtil.isIncluded(field, includedFields)) continue;
            results.add(field);
        }
        return results;
    }

    private static boolean isIncluded(ResourceField field, Set<PathSpec> includedFields) {
        return includedFields.contains(PathSpec.of(field.getUnderlyingName())) || includedFields.contains(PathSpec.of(field.getJsonName()));
    }

    protected static boolean noResourceIncludedFieldsSpecified(Set<PathSpec> typeIncludedFields) {
        return typeIncludedFields == null || typeIncludedFields.isEmpty();
    }

    public static <T> List<T> toList(Object entity) {
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof Iterable) {
            ArrayList result = new ArrayList();
            for (Object element : (Iterable)entity) {
                result.add(element);
            }
            return result;
        }
        return Collections.singletonList(entity);
    }

    public Link getRelationshipLink(Resource resource, ResourceField field, boolean related) {
        ObjectNode links = resource.getLinks();
        Link resourceLink = serializerUtil.getLinks(links, "self");
        if (resourceLink == null) {
            return null;
        }
        String href = resourceLink.getHref();
        String relationshipPath = (!related ? "/relationships/" : "/") + field.getJsonName();
        resourceLink.setHref(UrlUtils.appendRelativePath(href, relationshipPath));
        return resourceLink;
    }

    public List<ResourceIdentifier> toResourceIds(Collection<?> entities) {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (Object entity : entities) {
            results.add(this.toResourceId(entity));
        }
        return results;
    }

    public ResourceIdentifier toResourceId(Object entity) {
        if (entity == null) {
            return null;
        }
        RegistryEntry entry = this.resourceRegistry.findEntry(entity);
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.toResourceIdentifier(entity);
    }

    public void setLinks(LinksContainer container, LinksInformation linksInformation, QueryAdapter queryAdapter) {
        ObjectNode links;
        if (linksInformation != null) {
            LOGGER.debug("adding links information {}", (Object)linksInformation);
            container.setLinks((ObjectNode)this.objectMapper.valueToTree((Object)linksInformation));
        }
        if (queryAdapter != null && queryAdapter.getCompactMode() && (links = container.getLinks()) != null) {
            links.remove("self");
            if (!links.fieldNames().hasNext()) {
                container.setLinks(null);
            }
        }
    }

    public void setMeta(MetaContainer container, MetaInformation metaInformation) {
        if (metaInformation != null) {
            LOGGER.debug("adding meta information {}", (Object)metaInformation);
            container.setMeta((ObjectNode)this.objectMapper.valueToTree((Object)metaInformation));
        }
    }

    public ResourceInformation getResourceInformation(Object resource) {
        return this.resourceRegistry.findEntry(resource).getResourceInformation();
    }

    public ResourceInformation getResourceInformation(String resourceType) {
        return this.resourceRegistry.getEntry(resourceType).getResourceInformation();
    }

    public boolean hasResourceInformation(String resourceType) {
        return this.resourceRegistry.hasEntry(resourceType);
    }

    public String getSelfUrl(QueryContext queryContext, ResourceInformation resourceInformation, Object entity) {
        Object id = resourceInformation.getId(entity);
        return this.urlBuilder.buildUrl(queryContext, resourceInformation, id, null);
    }

    public static SerializerUtil getSerializerUtil() {
        return serializerUtil;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected static class DefaultSelfRelatedLinksInformation
    implements SelfLinksInformation,
    RelatedLinksInformation {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Link related;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Link self;

        protected DefaultSelfRelatedLinksInformation() {
        }

        @Override
        public Link getRelated() {
            return this.related;
        }

        @Override
        public void setRelated(Link related) {
            this.related = related;
        }

        @Override
        public Link getSelf() {
            return this.self;
        }

        @Override
        public void setSelf(Link self) {
            this.self = self;
        }
    }
}

