/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.internal.exception.CrnkExceptionMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperType;
import io.crnk.core.engine.internal.exception.TimeoutExceptionMapper;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.utils.Prioritizable;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionMapperRegistryBuilder {
    private List<ExceptionMapperType> exceptionMappers = new ArrayList<ExceptionMapperType>();

    public ExceptionMapperRegistry build(ExceptionMapperLookup exceptionMapperLookup) {
        for (ExceptionMapper exceptionMapper : exceptionMapperLookup.getExceptionMappers()) {
            this.registerExceptionMapper(exceptionMapper);
        }
        this.exceptionMappers = Prioritizable.prioritze(this.exceptionMappers);
        this.addDefaultMappers();
        return new ExceptionMapperRegistry(this.exceptionMappers);
    }

    private void addDefaultMappers() {
        this.registerExceptionMapper(new CrnkExceptionMapper());
        this.registerExceptionMapper(new TimeoutExceptionMapper());
    }

    private void registerExceptionMapper(ExceptionMapper<? extends Throwable> exceptionMapper) {
        Class<?> mapperClass = exceptionMapper.getClass();
        Class<? extends Throwable> exceptionClass = this.getGenericType(mapperClass);
        if (exceptionClass == null && this.isProxy(mapperClass)) {
            mapperClass = mapperClass.getSuperclass();
            exceptionClass = this.getGenericType(mapperClass);
        }
        this.exceptionMappers.add(new ExceptionMapperType(exceptionClass, exceptionMapper));
    }

    private boolean isProxy(Class<? extends ExceptionMapper> mapperClass) {
        return mapperClass.getName().contains("$$") && ExceptionMapper.class.isAssignableFrom(mapperClass.getSuperclass());
    }

    private Class<? extends Throwable> getGenericType(Class<? extends ExceptionMapper> mapper) {
        try {
            Type[] types = mapper.getGenericInterfaces();
            if (null == types || 0 == types.length) {
                types = new Type[]{mapper.getGenericSuperclass()};
            }
            for (Type type : types) {
                Class<?> rawType = ClassUtils.getRawType(type);
                if (!(type instanceof ParameterizedType) || !ExceptionMapper.class.isAssignableFrom(rawType)) continue;
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            if (this.isProxy(mapper)) {
                return this.getGenericType(mapper.getSuperclass());
            }
            throw new IllegalStateException("unable to discover exception class for " + mapper.getName());
        }
        catch (MalformedParameterizedTypeException e) {
            throw new IllegalStateException(mapper.getName(), e);
        }
    }
}

