/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessorHelper;
import io.crnk.core.exception.MethodNotAllowedException;
import io.crnk.core.module.Module;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiRequestProcessorBase {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Module.ModuleContext moduleContext;
    private Boolean acceptingPlainJson;
    protected JsonApiRequestProcessorHelper helper;

    public JsonApiRequestProcessorBase(Module.ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
        this.helper = new JsonApiRequestProcessorHelper(moduleContext);
    }

    protected boolean isAcceptingPlainJson() {
        if (this.acceptingPlainJson == null) {
            this.acceptingPlainJson = !Boolean.parseBoolean(this.moduleContext.getPropertiesProvider().getProperty("crnk.config.resource.request.rejectPlainJson"));
        }
        return this.acceptingPlainJson;
    }

    protected HttpResponse getErrorResponse(JsonProcessingException e) {
        String message = "Json Parsing failed";
        Response response = this.buildBadRequestResponse("Json Parsing failed", e.getMessage());
        this.logger.error("Json Parsing failed", (Throwable)e);
        return this.toHttpResponse(response);
    }

    protected HttpResponse buildMethodNotAllowedResponse(String method) {
        Document responseDocument = new Document();
        responseDocument.setErrors(Arrays.asList(MethodNotAllowedException.createErrorData(method)));
        Response response = new Response(responseDocument, 405);
        this.logger.warn("method not allowed: {}", (Object)method);
        return this.toHttpResponse(response);
    }

    protected HttpResponse toHttpResponse(Response response) {
        ObjectMapper objectMapper = this.moduleContext.getObjectMapper();
        HttpResponse httpResponse = response.toHttpResponse(objectMapper, this.getContentType());
        this.logger.debug("setup http resposne {}", (Object)httpResponse);
        return httpResponse;
    }

    protected String getContentType() {
        return "application/vnd.api+json; charset=utf-8";
    }

    protected Document getRequestDocument(HttpRequestContext requestContext) throws JsonProcessingException {
        byte[] requestBody = requestContext.getRequestBody();
        if (requestBody != null && requestBody.length > 0) {
            ObjectMapper objectMapper = this.moduleContext.getObjectMapper();
            try {
                return (Document)objectMapper.readerFor(Document.class).readValue(requestBody);
            }
            catch (JsonProcessingException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    protected Response buildBadRequestResponse(String message, String detail) {
        Document responseDocument = new Document();
        responseDocument.setErrors(Arrays.asList(ErrorData.builder().setStatus(String.valueOf(400)).setTitle(message).setDetail(detail).build()));
        return new Response(responseDocument, 400);
    }
}

