/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.io.IOException;
import java.util.Map;

public class RawResourceFieldAccessor
implements ResourceFieldAccessor {
    private final ResourceFieldType fieldType;
    private final String fieldName;
    private final Class type;
    private final ObjectReader reader;

    public RawResourceFieldAccessor(String fieldName, ResourceFieldType fieldType, Class type) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.type = type;
        ObjectMapper mapper = new ObjectMapper();
        this.reader = mapper.readerFor(type);
    }

    @Override
    public Object getValue(Object objResource) {
        Resource resource = (Resource)objResource;
        switch (this.fieldType) {
            case ID: {
                return resource.getId();
            }
            case ATTRIBUTE: {
                JsonNode jsonNode = resource.getAttributes().get(this.fieldName);
                return this.toObject(jsonNode);
            }
            case RELATIONSHIP: {
                Map<String, Relationship> relationships = resource.getRelationships();
                Relationship relationship = relationships.get(this.fieldName);
                if (relationship != null && relationship.getData().isPresent()) {
                    return relationship.getData().get();
                }
                return null;
            }
            case META_INFORMATION: {
                return this.toObject((JsonNode)resource.getMeta());
            }
        }
        PreconditionUtil.verifyEquals((Object)this.fieldType, (Object)ResourceFieldType.LINKS_INFORMATION, "invalid type", new Object[0]);
        return this.toObject((JsonNode)resource.getLinks());
    }

    private Object toObject(JsonNode node) {
        try {
            if (node == null) {
                return null;
            }
            return this.reader.readValue(node);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setValue(Object resource, Object fieldValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getImplementationClass() {
        return this.type;
    }
}

