/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import java.io.IOException;
import java.util.Map;

public class ErrorDataDeserializer
extends JsonDeserializer<ErrorData> {
    private static Map<String, Object> readMeta(JsonNode errorNode, JsonParser jp) throws IOException {
        JsonNode metaNode = errorNode.get("meta");
        if (metaNode != null) {
            return (Map)jp.getCodec().treeToValue((TreeNode)metaNode, Map.class);
        }
        return null;
    }

    private static String readSourcePointer(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return SerializerUtil.readStringIfExists("pointer", node);
        }
        return null;
    }

    private static String readSourceParameter(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return SerializerUtil.readStringIfExists("parameter", node);
        }
        return null;
    }

    private static String readAboutLink(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("links");
        if (node != null) {
            return SerializerUtil.deserializeLink("about", node);
        }
        return null;
    }

    public ErrorData deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        JsonNode errorNode = (JsonNode)jp.readValueAsTree();
        ErrorDataBuilder builder = ErrorData.builder();
        builder.setId(SerializerUtil.readStringIfExists("id", errorNode));
        builder.setAboutLink(ErrorDataDeserializer.readAboutLink(errorNode));
        builder.setStatus(SerializerUtil.readStringIfExists("status", errorNode));
        builder.setCode(SerializerUtil.readStringIfExists("code", errorNode));
        builder.setTitle(SerializerUtil.readStringIfExists("title", errorNode));
        builder.setDetail(SerializerUtil.readStringIfExists("detail", errorNode));
        builder.setMeta(ErrorDataDeserializer.readMeta(errorNode, jp));
        builder.setSourcePointer(ErrorDataDeserializer.readSourcePointer(errorNode));
        builder.setSourceParameter(ErrorDataDeserializer.readSourceParameter(errorNode));
        return builder.build();
    }
}

