/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ManyRelationshipRepository;
import io.crnk.core.repository.OneRelationshipRepository;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipRepositoryAdapterImpl
extends ResponseRepositoryAdapter
implements RelationshipRepositoryAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationshipRepositoryAdapterImpl.class);
    private final Object relationshipRepository;
    private final ResourceField field;

    public RelationshipRepositoryAdapterImpl(ResourceField field, ModuleRegistry moduleRegistry, Object relationshipRepository) {
        super(moduleRegistry);
        this.field = field;
        this.relationshipRepository = relationshipRepository;
    }

    @Override
    public Result<JsonApiResponse> setRelation(Object source, Object targetId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Serializable targetId = request.getId();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("setRelation {} on {} with {}", new Object[]{targetId, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                ((OneRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, Arrays.asList(targetId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> setRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Collection targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("setRelations {} on {} with {}", new Object[]{targetIds, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                ((ManyRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> addRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Collection targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("addRelation {} on {} with {}", new Object[]{targetIds, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                ((ManyRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.POST, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> removeRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Collection targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("removeRelations {} on {} with {}", new Object[]{targetIds, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                ((ManyRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.DELETE, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findOneRelations(Object sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("findOneRelations for sourceId={} on {} with {}", new Object[]{sourceId, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                OneRelationshipRepository querySpecRepository = (OneRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                Map map = querySpecRepository.findOneRelations(Arrays.asList(sourceId), field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                Object resource = map.get(sourceId);
                return RelationshipRepositoryAdapterImpl.this.getResponse(RelationshipRepositoryAdapterImpl.this.relationshipRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findManyRelations(Object sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                LOGGER.debug("findManyRelations for sourceId={} on {} with {}", new Object[]{sourceId, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                ManyRelationshipRepository querySpecRepository = (ManyRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                Map map = querySpecRepository.findManyRelations(Arrays.asList(sourceId), field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                ResourceList resources = map.get(sourceId);
                return RelationshipRepositoryAdapterImpl.this.getResponse(RelationshipRepositoryAdapterImpl.this.relationshipRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<Map<Object, JsonApiResponse>> findBulkManyTargets(Collection sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof ManyRelationshipRepository) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl(){

                protected Map<Object, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Collection sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    LOGGER.debug("findManyTargets for sourceIds={} on {} with {}", new Object[]{sourceIds, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                    ManyRelationshipRepository bulkRepository = (ManyRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    QuerySpec querySpec = request.getQuerySpec(targetResourceInformation);
                    Map targetsMap = bulkRepository.findManyRelations(sourceIds, field.getUnderlyingName(), querySpec);
                    return RelationshipRepositoryAdapterImpl.this.toResponses(targetsMap, true, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, new ArrayList(sourceIds), field);
            return new ImmediateResult<Map<Object, JsonApiResponse>>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
        }
        HashMap responseMap = new HashMap();
        for (Object sourceId : sourceIds) {
            JsonApiResponse response = this.findManyRelations(sourceId, field, queryAdapter).get();
            responseMap.put(sourceId, response);
        }
        return new ImmediateResult<Map<Object, JsonApiResponse>>(responseMap);
    }

    @Override
    public Result<Map<Object, JsonApiResponse>> findBulkOneTargets(Collection sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof OneRelationshipRepository) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl(){

                protected Map<Object, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Collection sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    OneRelationshipRepository bulkRepository = (OneRelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    LOGGER.debug("findOneRelations for sourceId={} on {} with {}", new Object[]{sourceIds, field, RelationshipRepositoryAdapterImpl.this.relationshipRepository});
                    Map targetsMap = bulkRepository.findOneRelations(sourceIds, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                    return RelationshipRepositoryAdapterImpl.this.toResponses(targetsMap, false, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, new ArrayList(sourceIds), field);
            return new ImmediateResult<Map<Object, JsonApiResponse>>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
        }
        HashMap responseMap = new HashMap();
        for (Object sourceId : sourceIds) {
            JsonApiResponse response = this.findOneRelations(sourceId, field, queryAdapter).get();
            responseMap.put(sourceId, response);
        }
        return new ImmediateResult<Map<Object, JsonApiResponse>>(responseMap);
    }

    private Map<Object, JsonApiResponse> toResponses(Map targetsMap, boolean isMany, QueryAdapter queryAdapter, ResourceField field, HttpMethod method) {
        HashMap<Object, JsonApiResponse> responseMap = new HashMap<Object, JsonApiResponse>();
        for (Object sourceId : targetsMap.keySet()) {
            Object targets = targetsMap.get(sourceId);
            RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, method, null, queryAdapter, Collections.singleton(sourceId), field);
            JsonApiResponse response = this.getResponse(this.relationshipRepository, targets, requestSpec);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    @Override
    public Object getImplementation() {
        return this.relationshipRepository;
    }

    @Override
    public ResourceField getResourceField() {
        return this.field;
    }
}

