/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.AbstractPathSpec;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.PathSpec;
import java.io.Serializable;
import java.util.List;

public class SortSpec
extends AbstractPathSpec
implements Serializable {
    private static final long serialVersionUID = -3547744992729509448L;
    private Direction direction;

    public SortSpec(List<String> path, Direction direction) {
        this(PathSpec.of(path), direction);
    }

    public SortSpec(PathSpec path, Direction direction) {
        super(path);
        PreconditionUtil.verify(path != null && !path.isEmpty(), "path cannot be empty", new Object[0]);
        PreconditionUtil.verify(direction != null, "direction cannot be null for path %s", path);
        this.direction = direction;
    }

    public static SortSpec asc(List<String> expression) {
        return new SortSpec(expression, Direction.ASC);
    }

    public static SortSpec desc(List<String> attributeName) {
        return new SortSpec(attributeName, Direction.DESC);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public SortSpec reverse() {
        return new SortSpec(this.path, this.direction == Direction.ASC ? Direction.DESC : Direction.ASC);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        return super.hashCode() | result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SortSpec other = (SortSpec)obj;
        return this.direction == other.direction;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.path.toString());
        b.append(' ');
        b.append((Object)this.direction);
        return b.toString();
    }

    public SortSpec clone() {
        return new SortSpec(this.path.clone(), this.direction);
    }

    public void setDirection(Direction dir) {
        this.direction = dir;
    }
}

