/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import java.util.Map;
import java.util.Set;

public class QuerySpecAdapterBuilder
implements QueryAdapterBuilder {
    private QuerySpecUrlMapper querySpecUrlMapper;
    private ModuleRegistry moduleRegistry;

    public QuerySpecAdapterBuilder(QuerySpecUrlMapper querySpecUrlMapper, ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.querySpecUrlMapper = querySpecUrlMapper;
    }

    @Override
    public QueryAdapter build(ResourceInformation resourceInformation, Map<String, Set<String>> parameters, QueryContext queryContext) {
        QuerySpecAdapter adapter = new QuerySpecAdapter(this.querySpecUrlMapper.deserialize(resourceInformation, parameters, queryContext), this.moduleRegistry.getResourceRegistry(), queryContext);
        HttpRequestContext requestContext = this.moduleRegistry.getHttpRequestContextProvider().getRequestContext();
        if (requestContext != null) {
            adapter.setCompactMode(Boolean.parseBoolean(requestContext.getRequestHeader("Crnk-Compact")));
        }
        return adapter;
    }
}

