/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal.typed;

import io.crnk.core.queryspec.AbstractPathSpec;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.SortSpec;
import java.util.ArrayList;

public abstract class PathSpecBase
extends PathSpec {
    protected AbstractPathSpec boundSpec;

    protected PathSpecBase(PathSpec pathSpec) {
        this.elements = pathSpec.getElements();
    }

    protected PathSpecBase(AbstractPathSpec boundSpec) {
        this(boundSpec.getPath());
        this.boundSpec = boundSpec;
    }

    protected abstract PathSpec bindSpec(AbstractPathSpec var1);

    @Override
    public SortSpec sort(Direction dir) {
        if (this.boundSpec != null) {
            SortSpec sortSpec = (SortSpec)this.boundSpec;
            sortSpec.setDirection(dir);
            return sortSpec;
        }
        return new SortSpec(this, dir);
    }

    @Override
    public FilterSpec filter(FilterOperator operator, Object value) {
        if (this.boundSpec != null) {
            FilterSpec filterSpec = (FilterSpec)this.boundSpec;
            filterSpec.setOperator(operator);
            filterSpec.setValue(value);
            return filterSpec;
        }
        return new FilterSpec(this, operator, value);
    }

    @Override
    public PathSpec append(String fieldName) {
        ArrayList<String> copy = new ArrayList<String>(this.elements);
        copy.add(fieldName);
        PathSpec updatedPathSpec = PathSpec.of(copy);
        if (this.boundSpec != null) {
            this.boundSpec.setPath(updatedPathSpec);
        }
        return updatedPathSpec;
    }
}

