/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.BulkRelationshipRepository;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Deprecated
public class RelationshipRepositoryBase<T, I, D, J>
implements BulkRelationshipRepository<T, I, D, J>,
ResourceRegistryAware,
HttpRequestContextAware {
    protected ResourceRegistry resourceRegistry;
    private Class<T> sourceResourceClass;
    private String sourceResourceType;
    private Class targetResourceClass;
    private String targetResourceType;
    private HttpRequestContextProvider requestContextProvider;

    protected RelationshipRepositoryBase() {
    }

    public RelationshipRepositoryBase(Class<T> sourceResourceClass, Class<D> targetResourceClass) {
        this(sourceResourceClass);
        this.targetResourceClass = targetResourceClass;
    }

    public RelationshipRepositoryBase(String sourceResourceType, String targetResourceType) {
        this(sourceResourceType);
        this.targetResourceType = targetResourceType;
    }

    public RelationshipRepositoryBase(Class<T> sourceResourceClass) {
        this.sourceResourceClass = sourceResourceClass;
    }

    public RelationshipRepositoryBase(String sourceResourceType) {
        this.sourceResourceType = sourceResourceType;
    }

    @Override
    public RelationshipMatcher getMatcher() {
        RelationshipMatcher matcher = new RelationshipMatcher();
        matcher.rule().source(this.sourceResourceType).source(this.sourceResourceClass).target(this.targetResourceType).target(this.targetResourceClass).add();
        return matcher;
    }

    @Override
    public D findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Object, D> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        if (map.isEmpty()) {
            return null;
        }
        return map.getUnique(sourceId);
    }

    @Override
    public ResourceList<D> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        MultivaluedMap<Object, D> map = this.findTargets(Arrays.asList(sourceId), fieldName, querySpec);
        if (map.isEmpty()) {
            return new DefaultResourceList();
        }
        return (ResourceList)map.getList(sourceId);
    }

    @Override
    public void setRelation(T source, J targetId, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            field.getIdAccessor().setValue(source, targetId);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            D target = this.getTarget(targetEntry, targetId);
            field.getAccessor().setValue(source, target);
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void setRelations(T source, Collection<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            field.getIdAccessor().setValue(source, targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Collection<D> targets = this.getTargets(targetEntry, targetIds);
            field.getAccessor().setValue(source, targets);
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void addRelations(T source, Collection<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            Collection currentIds = (Collection)field.getIdAccessor().getValue(source);
            currentIds.addAll(targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Collection<D> targets = this.getTargets(targetEntry, targetIds);
            Collection<D> currentTargets = this.getOrCreateCollection(source, fieldName);
            for (D target : targets) {
                currentTargets.add(target);
            }
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    @Override
    public void removeRelations(T source, Collection<J> targetIds, String fieldName) {
        RegistryEntry sourceEntry = this.getSourceEntry();
        ResourceRepositoryAdapter sourceAdapter = sourceEntry.getResourceRepository();
        ResourceInformation sourceInformation = this.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        if (field.hasIdField()) {
            Collection currentIds = (Collection)field.getIdAccessor().getValue(source);
            currentIds.removeAll(targetIds);
        } else {
            RegistryEntry targetEntry = this.getTargetEntry(field);
            Collection<D> targets = this.getTargets(targetEntry, targetIds);
            Collection<D> currentTargets = this.getOrCreateCollection(source, fieldName);
            for (D target : targets) {
                currentTargets.remove(target);
            }
        }
        sourceAdapter.update(source, this.getSaveQueryAdapter(fieldName));
    }

    protected QueryAdapter getSaveQueryAdapter(String fieldName) {
        QuerySpec querySpec = this.newSourceQuerySpec();
        querySpec.includeRelation(Arrays.asList(fieldName));
        QueryContext queryContext = this.requestContextProvider.getRequestContext().getQueryContext();
        return new QuerySpecAdapter(querySpec, this.resourceRegistry, queryContext);
    }

    private QuerySpec newSourceQuerySpec() {
        return new QuerySpec(this.sourceResourceClass, this.sourceResourceType);
    }

    private Collection<D> getOrCreateCollection(Object source, String fieldName) {
        AbstractCollection property = PropertyUtils.getProperty(source, fieldName);
        if (property == null) {
            Class<?> propertyClass = PropertyUtils.getPropertyClass(source.getClass(), fieldName);
            boolean isList = List.class.isAssignableFrom(propertyClass);
            property = isList ? new ArrayList() : new HashSet();
            PropertyUtils.setProperty(source, fieldName, property);
        }
        return property;
    }

    @Deprecated
    protected Collection<D> getTargets(Collection<J> targetIds) {
        RegistryEntry entry = this.resourceRegistry.getEntry(this.targetResourceClass);
        return this.getTargets(entry, targetIds);
    }

    @Deprecated
    protected D getTargets(J targetId) {
        RegistryEntry entry = this.resourceRegistry.getEntry(this.targetResourceClass);
        return this.getTarget(entry, targetId);
    }

    protected D getTarget(RegistryEntry entry, J targetId) {
        if (targetId == null) {
            return null;
        }
        ResourceRepositoryAdapter targetAdapter = entry.getResourceRepository();
        QueryContext queryContext = this.requestContextProvider.getRequestContext().getQueryContext();
        QuerySpecAdapter queryAdapter = new QuerySpecAdapter(new QuerySpec(entry.getResourceInformation()), this.resourceRegistry, queryContext);
        Object target = targetAdapter.findOne(targetId, queryAdapter).get().getEntity();
        PreconditionUtil.assertNotNull("related resource not found", target);
        return (D)target;
    }

    protected Collection<D> getTargets(RegistryEntry entry, Collection<J> targetIds) {
        ResourceRepositoryAdapter targetAdapter = entry.getResourceRepository();
        QueryContext queryContext = this.requestContextProvider.getRequestContext().getQueryContext();
        QuerySpecAdapter queryAdapter = new QuerySpecAdapter(new QuerySpec(entry.getResourceInformation()), this.resourceRegistry, queryContext);
        return (Collection)targetAdapter.findAll(targetIds, queryAdapter).get().getEntity();
    }

    @Override
    public MultivaluedMap<I, D> findTargets(Collection<I> sourceIds, String fieldName, QuerySpec querySpec) {
        RegistryEntry sourceEntry = this.resourceRegistry.findEntry(this.sourceResourceClass);
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        RegistryEntry targetEntry = this.getTargetEntry(field);
        String oppositeName = this.getOppositeName(fieldName);
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(oppositeName, sourceInformation.getIdField().getUnderlyingName()), FilterOperator.EQ, sourceIds));
        idQuerySpec.includeRelation(Arrays.asList(oppositeName));
        ResourceRepositoryAdapter targetAdapter = targetEntry.getResourceRepository();
        QueryContext queryContext = this.requestContextProvider.getRequestContext().getQueryContext();
        JsonApiResponse response = targetAdapter.findAll(new QuerySpecAdapter(idQuerySpec, this.resourceRegistry, queryContext)).get();
        List results = (List)response.getEntity();
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        HashSet<I> sourceIdSet = new HashSet<I>();
        for (I sourceId : sourceIds) {
            sourceIdSet.add(sourceId);
            bulkResult.set(sourceId, new DefaultResourceList());
        }
        for (Object result : results) {
            this.handleTarget(bulkResult, result, sourceIdSet, oppositeName, sourceInformation);
        }
        return bulkResult;
    }

    private void handleTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, String oppositeName, ResourceInformation sourceInformation) {
        Object property = PropertyUtils.getProperty(result, oppositeName);
        if (property == null) {
            throw new IllegalStateException("field " + oppositeName + " is null for " + result + ", make sure to properly implement relationship inclusions");
        }
        if (property instanceof Collection) {
            for (Object potentialSource : (Collection)property) {
                Object sourceId = sourceInformation.getId(potentialSource);
                PreconditionUtil.assertNotNull("id must not be null", sourceId);
                if (!sourceIdSet.contains(sourceId)) continue;
                bulkResult.add(sourceId, result);
            }
        } else {
            Object source = property;
            Object sourceId = sourceInformation.getId(source);
            PreconditionUtil.assertTrue("filtering not properly implemented in resource repository", sourceIdSet.contains(sourceId));
            PreconditionUtil.assertNotNull("id must not be null", sourceId);
            bulkResult.add(sourceId, result);
        }
    }

    protected String getOppositeName(String fieldName) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.sourceResourceClass);
        ResourceInformation resourceInformation = entry.getResourceInformation();
        ResourceField field = resourceInformation.findFieldByUnderlyingName(fieldName);
        PreconditionUtil.verify(field != null, "field %s.%s not found", resourceInformation.getResourceType(), fieldName);
        PreconditionUtil.verify(field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP, "field %s.%s must be a relationship to be referenced by other relationship", resourceInformation.getResourceType(), fieldName);
        String oppositeName = field.getOppositeName();
        PreconditionUtil.verify(oppositeName != null, "opposite not specified for %s.%s", resourceInformation.getResourceType(), fieldName);
        return oppositeName;
    }

    protected RegistryEntry getSourceEntry() {
        if (this.sourceResourceType != null) {
            return this.resourceRegistry.getEntry(this.sourceResourceType);
        }
        return this.resourceRegistry.findEntry(this.sourceResourceClass);
    }

    protected RegistryEntry getTargetEntry(ResourceField field) {
        return this.resourceRegistry.getEntry(field.getOppositeResourceType());
    }

    @Override
    public Class<T> getSourceResourceClass() {
        return this.sourceResourceClass;
    }

    @Override
    public Class<D> getTargetResourceClass() {
        return this.targetResourceClass;
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public void setHttpRequestContextProvider(HttpRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }
}

