/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.foward;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.BulkRelationshipRepository;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.foward.ForwardingDirection;
import io.crnk.core.repository.foward.strategy.ForwardingGetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingSetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyContext;
import io.crnk.core.repository.foward.strategy.GetFromOppositeStrategy;
import io.crnk.core.repository.foward.strategy.GetFromOwnerStrategy;
import io.crnk.core.repository.foward.strategy.SetOppositeStrategy;
import io.crnk.core.repository.foward.strategy.SetOwnerStrategy;
import io.crnk.core.resource.links.Link;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.list.ResourceList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingRelationshipRepository<T, I, D, J>
implements BulkRelationshipRepository<T, I, D, J>,
ResourceRegistryAware,
HttpRequestContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardingRelationshipRepository.class);
    private RelationshipMatcher matcher;
    private ForwardingGetStrategy getStrategy;
    private ForwardingSetStrategy setStrategy;
    private Class<T> sourceClass;
    private String sourceType;
    private ForwardingStrategyContext context;
    private HttpRequestContextProvider requestContextProvider;

    protected ForwardingRelationshipRepository() {
    }

    public ForwardingRelationshipRepository(Class<T> sourceClass, RelationshipMatcher matcher, ForwardingDirection getDirection, ForwardingDirection setDirection) {
        this(sourceClass, matcher, ForwardingRelationshipRepository.toGetStrategy(getDirection), ForwardingRelationshipRepository.toSetStrategy(setDirection));
    }

    public ForwardingRelationshipRepository(Class<T> sourceClass, RelationshipMatcher matcher, ForwardingGetStrategy<T, I, D, J> getStrategy, ForwardingSetStrategy<T, I, D, J> setStrategy) {
        this.sourceClass = sourceClass;
        this.matcher = matcher;
        this.getStrategy = getStrategy;
        this.setStrategy = setStrategy;
    }

    public ForwardingRelationshipRepository(String sourceType, RelationshipMatcher matcher, ForwardingDirection getDirection, ForwardingDirection setDirection) {
        this(sourceType, matcher, ForwardingRelationshipRepository.toGetStrategy(getDirection), ForwardingRelationshipRepository.toSetStrategy(setDirection));
    }

    private static ForwardingGetStrategy toGetStrategy(ForwardingDirection direction) {
        return direction == ForwardingDirection.OWNER ? new GetFromOwnerStrategy() : new GetFromOppositeStrategy();
    }

    private static ForwardingSetStrategy toSetStrategy(ForwardingDirection direction) {
        return direction == ForwardingDirection.OWNER ? new SetOwnerStrategy() : new SetOppositeStrategy();
    }

    public ForwardingRelationshipRepository(String sourceType, RelationshipMatcher matcher, ForwardingGetStrategy<T, I, D, J> getStrategy, ForwardingSetStrategy<T, I, D, J> setStrategy) {
        this.sourceType = sourceType;
        this.matcher = matcher;
        this.getStrategy = getStrategy;
        this.setStrategy = setStrategy;
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        if (this.context == null) {
            this.context = new ForwardingStrategyContext(resourceRegistry, this.sourceType, this.sourceClass);
            this.getStrategy.init(this.context);
            this.setStrategy.init(this.context);
        }
    }

    @Override
    public RelationshipMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public Class<T> getSourceResourceClass() {
        throw new UnsupportedOperationException("deprecated and no longer supported");
    }

    @Override
    public Class<D> getTargetResourceClass() {
        throw new UnsupportedOperationException("deprecated and no longer supported");
    }

    @Override
    public void setRelation(T source, J targetId, String fieldName) {
        LOGGER.debug("set relation {}={} with {}", new Object[]{fieldName, targetId, this.setStrategy});
        QueryContext queryContext = this.getQueryContext();
        this.setStrategy.setRelation(source, targetId, fieldName, queryContext);
    }

    @Override
    public void setRelations(T source, Collection<J> targetIds, String fieldName) {
        LOGGER.debug("set relations {}={} with {}", new Object[]{fieldName, targetIds, this.setStrategy});
        QueryContext queryContext = this.getQueryContext();
        this.setStrategy.setRelations(source, targetIds, fieldName, queryContext);
    }

    @Override
    public void addRelations(T source, Collection<J> targetIds, String fieldName) {
        LOGGER.debug("add relations {}={} with {}", new Object[]{fieldName, targetIds, this.setStrategy});
        QueryContext queryContext = this.getQueryContext();
        this.setStrategy.addRelations(source, targetIds, fieldName, queryContext);
    }

    @Override
    public void removeRelations(T source, Collection<J> targetIds, String fieldName) {
        LOGGER.debug("remove relations {}={} with {}", new Object[]{fieldName, targetIds, this.setStrategy});
        QueryContext queryContext = this.getQueryContext();
        this.setStrategy.removeRelations(source, targetIds, fieldName, queryContext);
    }

    @Override
    public MultivaluedMap<I, D> findTargets(Collection<I> sourceIds, String fieldName, QuerySpec querySpec) {
        LOGGER.debug("findTargets {} for {} with {}", new Object[]{fieldName, querySpec, this.getStrategy});
        QueryContext queryContext = this.getQueryContext();
        MultivaluedMap targets = this.getStrategy.findTargets(sourceIds, fieldName, querySpec, queryContext);
        for (List list : targets.values()) {
            ResourceList resourceList;
            LinksInformation links;
            if (!(list instanceof ResourceList) || !((links = (resourceList = (ResourceList)list).getLinks()) instanceof SelfLinksInformation)) continue;
            ((SelfLinksInformation)links).setSelf((Link)null);
        }
        return targets;
    }

    protected QueryContext getQueryContext() {
        HttpRequestContext requestContext = this.requestContextProvider.getRequestContext();
        return requestContext != null ? requestContext.getQueryContext() : new QueryContext();
    }

    @Override
    public void setHttpRequestContextProvider(HttpRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }
}

