/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.foward.strategy;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.repository.foward.strategy.ForwardingSetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyBase;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyContext;
import io.crnk.core.repository.foward.strategy.SetOwnerStrategy;
import java.util.Arrays;
import java.util.Collection;

public class SetOppositeStrategy<T, I, D, J>
extends ForwardingStrategyBase
implements ForwardingSetStrategy<T, I, D, J> {
    private SetOwnerStrategy oppositeSetStrategy = new SetOwnerStrategy();

    @Override
    public void init(ForwardingStrategyContext context) {
        super.init(context);
        this.oppositeSetStrategy.init(context);
    }

    @Override
    public void setRelation(T source, J relatedId, String fieldName, QueryContext queryContext) {
        Object targetId = relatedId;
        boolean add = relatedId != null;
        boolean exists = true;
        if (!add) {
            ResourceInformation resourceInformation = this.context.getSourceEntry().getResourceInformation();
            ResourceField field = resourceInformation.findFieldByUnderlyingName(fieldName);
            if (field.hasIdField()) {
                targetId = field.getIdAccessor().getValue(source);
            } else {
                Object target = field.getAccessor().getValue(source);
                boolean bl = exists = target != null;
                if (exists) {
                    ResourceInformation targetInformation = this.context.getTargetEntry(field).getResourceInformation();
                    targetId = targetInformation.getId(target);
                }
            }
        }
        if (exists) {
            this.updateRelations(source, Arrays.asList(targetId), fieldName, queryContext, add);
        }
    }

    @Override
    public void setRelations(T source, Collection<J> targetIds, String fieldName, QueryContext queryContext) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void addRelations(T source, Collection<J> targetIds, String fieldName, QueryContext queryContext) {
        this.updateRelations(source, targetIds, fieldName, queryContext, true);
    }

    @Override
    public void removeRelations(T source, Collection<J> targetIds, String fieldName, QueryContext queryContext) {
        this.updateRelations(source, targetIds, fieldName, queryContext, false);
    }

    private void updateRelations(T source, Collection<J> targetIds, String fieldName, QueryContext queryContext, boolean add) {
        ResourceInformation sourceInformation = this.context.getSourceEntry().getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        PreconditionUtil.verify(field != null, "field not found: %s.%s", sourceInformation.getResourceType(), fieldName);
        RegistryEntry targetEntry = this.context.getTargetEntry(field);
        ResourceField oppositeField = this.getOppositeField(field);
        ResourceFieldAccessor oppositeAccessor = oppositeField.getAccessor();
        ResourceRepositoryAdapter targetRepository = targetEntry.getResourceRepository();
        QueryAdapter queryAdapter = this.context.createEmptyQueryAdapter(targetEntry, queryContext);
        Collection targets = this.context.findAll(targetEntry, targetIds, queryContext);
        for (Object target : targets) {
            if (oppositeField.isCollection()) {
                Collection oppositeElements = (Collection)oppositeAccessor.getValue(target);
                if (add) {
                    oppositeElements.add(source);
                } else {
                    oppositeElements.remove(source);
                }
                targetRepository.update(target, queryAdapter);
                continue;
            }
            oppositeAccessor.setValue(target, add ? source : null);
            targetRepository.update(target, queryAdapter);
        }
    }

    private ResourceField getOppositeField(ResourceField field) {
        String oppositeName = field.getOppositeName();
        PreconditionUtil.verify(oppositeName != null, "no opposite field set for %s.%s", field.getResourceInformation().getResourceType(), field.getUnderlyingName());
        RegistryEntry targetEntry = this.context.getTargetEntry(field);
        return targetEntry.getResourceInformation().findFieldByUnderlyingName(oppositeName);
    }
}

