/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.error;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponseBuilder;
import io.crnk.core.repository.response.JsonApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class ErrorResponse {
    public static final String ERRORS = "errors";
    private final Collection<ErrorData> data;
    private final int httpStatus;

    public ErrorResponse(Collection<ErrorData> data, int httpStatus) {
        this.data = data;
        this.httpStatus = httpStatus;
    }

    public static ErrorResponseBuilder builder() {
        return new ErrorResponseBuilder();
    }

    public Collection<ErrorData> getErrors() {
        if (this.data == null) {
            return Collections.emptyList();
        }
        return this.data;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public JsonApiResponse getResponse() {
        return new JsonApiResponse().setErrors(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)o;
        return Objects.equals(this.httpStatus, that.httpStatus) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.httpStatus);
    }

    public Response toResponse() {
        Document responseDocument = new Document();
        ArrayList<ErrorData> errors = new ArrayList<ErrorData>();
        for (ErrorData error : this.getErrors()) {
            errors.add(error);
        }
        responseDocument.setErrors(errors);
        return new Response(responseDocument, this.getHttpStatus());
    }
}

