/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.http;

import io.crnk.core.engine.http.HttpRequestContextBase;
import java.net.URI;

public abstract class DefaultHttpRequestContextBase
implements HttpRequestContextBase {
    private boolean readForwardedHeader = true;

    public boolean getReadForwardedHeader() {
        return this.readForwardedHeader;
    }

    public void setReadForwardedHeader(boolean readForwardedHeader) {
        this.readForwardedHeader = readForwardedHeader;
    }

    @Override
    public final URI getRequestUri() {
        URI requestUri = this.getNativeRequestUri();
        if (this.readForwardedHeader) {
            String forwardedProto = this.getRequestHeader("X-Forwarded-Proto");
            String scheme = requestUri.getScheme();
            if (forwardedProto != null && scheme != null && scheme.equals("http")) {
                requestUri = URI.create(forwardedProto + "://" + requestUri.toString().substring(7));
            }
        }
        return requestUri;
    }

    protected abstract URI getNativeRequestUri();
}

