/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.internal.utils.ClassUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanInformationBase {
    protected final Class<?> implementationClass;
    protected final Type implementationType;
    private List<ResourceField> attributeFields;
    protected List<ResourceField> fields;
    private Map<String, List<ResourceField>> fieldVersionsByJsonName = new HashMap<String, List<ResourceField>>();
    private Map<String, ResourceField> fieldByUnderlyingName = new HashMap<String, ResourceField>();
    private Map<String, ResourceFieldAccessor> fieldAccessors = new HashMap<String, ResourceFieldAccessor>();

    public BeanInformationBase(Type implementationType, List<ResourceField> fields) {
        this.implementationClass = ClassUtils.getRawType(implementationType);
        this.implementationType = implementationType;
        this.fields = fields;
    }

    public ResourceField findFieldByUnderlyingName(String name) {
        return this.fieldByUnderlyingName.get(name);
    }

    public boolean hasJsonField(String jsonName) {
        return this.fieldVersionsByJsonName.containsKey(jsonName);
    }

    public List<ResourceField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    public List<ResourceField> getAttributeFields() {
        return this.attributeFields;
    }

    public ResourceField findFieldByJsonName(String jsonName, int version) {
        List<ResourceField> fieldVersions = this.fieldVersionsByJsonName.get(jsonName);
        if (fieldVersions != null) {
            for (ResourceField field : fieldVersions) {
                if (!field.getVersionRange().contains(version)) continue;
                return field;
            }
        }
        return null;
    }

    @Deprecated
    public ResourceField findFieldByName(String name) {
        return this.findFieldByJsonName(name, Integer.MAX_VALUE);
    }

    @Deprecated
    public ResourceField findAttributeFieldByName(String name) {
        ResourceField resourceField = this.findFieldByName(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.ATTRIBUTE ? resourceField : null;
    }

    protected void initFields() {
        if (this.fields != null) {
            this.attributeFields = ResourceFieldType.ATTRIBUTE.filter(this.fields);
            for (ResourceField resourceField : this.fields) {
                this.initField(resourceField);
            }
        } else {
            this.fieldAccessors = null;
            this.attributeFields = Collections.emptyList();
        }
    }

    protected void initField(ResourceField resourceField) {
        String jsonName = resourceField.getJsonName();
        List list = this.fieldVersionsByJsonName.getOrDefault(jsonName, new ArrayList());
        list.add(resourceField);
        this.fieldVersionsByJsonName.put(jsonName, list);
        this.fieldByUnderlyingName.put(resourceField.getUnderlyingName(), resourceField);
        this.fieldAccessors.put(resourceField.getUnderlyingName(), resourceField.getAccessor());
        if (resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP && resourceField.hasIdField()) {
            this.fieldAccessors.put(resourceField.getIdName(), resourceField.getIdAccessor());
            if (!this.fieldByUnderlyingName.containsKey(resourceField.getIdName())) {
                this.fieldByUnderlyingName.put(resourceField.getIdName(), resourceField);
            }
        }
    }

    @Deprecated
    public void setFields(List<ResourceField> fields) {
        this.fields = fields;
        this.initFields();
    }

    public ResourceFieldAccessor getAccessor(String name) {
        return this.fieldAccessors.get(name);
    }
}

