/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import io.crnk.core.engine.internal.utils.PreconditionUtil;

public class VersionRange {
    public static final VersionRange UNBOUNDED = VersionRange.of(0, Integer.MAX_VALUE);
    private int min;
    private int max;

    private VersionRange() {
    }

    public static VersionRange of(int min, int max) {
        VersionRange versionRange = new VersionRange();
        versionRange.min = min;
        versionRange.max = max;
        return versionRange;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean contains(int version) {
        PreconditionUtil.verify(version >= 0, "version not set", new Object[0]);
        return this.min <= version && version <= this.max;
    }
}

