/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpStatusBehavior;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Supplier;
import java.util.List;
import java.util.Objects;

public class ControllerContext {
    private final ModuleRegistry moduleRegistry;
    private Supplier<DocumentMapper> documentMapper;

    public ControllerContext(ModuleRegistry moduleRegistry, Supplier<DocumentMapper> documentMapper) {
        this.moduleRegistry = Objects.requireNonNull(moduleRegistry);
        this.documentMapper = documentMapper;
    }

    public ResourceFilterDirectory getResourceFilterDirectory() {
        return this.moduleRegistry.getContext().getResourceFilterDirectory();
    }

    public ResourceRegistry getResourceRegistry() {
        return this.moduleRegistry.getResourceRegistry();
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.moduleRegistry.getPropertiesProvider();
    }

    public TypeParser getTypeParser() {
        return this.moduleRegistry.getTypeParser();
    }

    public ObjectMapper getObjectMapper() {
        return this.moduleRegistry.getContext().getObjectMapper();
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper.get();
    }

    public List<ResourceModificationFilter> getModificationFilters() {
        return this.moduleRegistry.getResourceModificationFilters();
    }

    public ResultFactory getResultFactory() {
        return this.moduleRegistry.getContext().getResultFactory();
    }

    public HttpStatusBehavior getHttpStatusBehavior() {
        return this.moduleRegistry.getHttpStatusProvider();
    }

    public DocumentMappingConfig getMappingConfig() {
        return this.moduleRegistry.getDocumentMappingConfig();
    }
}

