/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.IncludeBehavior;
import io.crnk.core.engine.internal.document.mapper.IncludeRequest;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncludeLookupUtil {
    private ResourceRegistry resourceRegistry;
    private IncludeBehavior includeBehavior;

    public IncludeLookupUtil(ResourceRegistry resourceRegistry, IncludeBehavior includeBehavior) {
        this.resourceRegistry = resourceRegistry;
        this.includeBehavior = includeBehavior;
    }

    public static List<Serializable> getIds(Collection<Resource> resources, ResourceInformation resourceInformation) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (Resource resource : resources) {
            if (resource.getId() == null) continue;
            Serializable id = resourceInformation.parseIdString(resource.getId());
            ids.add(id);
        }
        return ids;
    }

    public static LookupIncludeBehavior getGlobalLookupIncludeBehavior(PropertiesProvider propertiesProvider) {
        if (propertiesProvider == null) {
            return LookupIncludeBehavior.DEFAULT;
        }
        String strDefaultLookupBehavior = propertiesProvider.getProperty("crnk.config.lookup.behavior.default");
        if (strDefaultLookupBehavior != null) {
            return LookupIncludeBehavior.valueOf(strDefaultLookupBehavior);
        }
        return LookupIncludeBehavior.DEFAULT;
    }

    public static IncludeBehavior getIncludeBehavior(PropertiesProvider propertiesProvider) {
        String property;
        String string = property = propertiesProvider != null ? propertiesProvider.getProperty("crnk.config.include.behavior") : null;
        if (property == null || property.isEmpty()) {
            return IncludeBehavior.PER_TYPE;
        }
        return IncludeBehavior.valueOf(property.toUpperCase());
    }

    public Set<ResourceField> getRelationshipFields(Collection<Resource> resources) {
        HashSet<ResourceField> fields = new HashSet<ResourceField>();
        HashSet<String> processedTypes = new HashSet<String>();
        for (Resource resource : resources) {
            this.process(resource.getType(), processedTypes, fields);
        }
        return fields;
    }

    private void process(String type, Set<String> processedTypes, Set<ResourceField> fields) {
        if (!processedTypes.contains(type)) {
            processedTypes.add(type);
            RegistryEntry entry = this.resourceRegistry.getEntry(type);
            ResourceInformation information = entry.getResourceInformation();
            ResourceInformation superInformation = this.getSuperInformation(information);
            if (superInformation != null) {
                this.process(superInformation.getResourceType(), processedTypes, fields);
            }
            for (ResourceField field : information.getRelationshipFields()) {
                boolean existsOnSuperType = superInformation != null && superInformation.findFieldByUnderlyingName(field.getUnderlyingName()) != null;
                if (existsOnSuperType) continue;
                fields.add(field);
            }
        }
    }

    private ResourceInformation getSuperInformation(ResourceInformation information) {
        String superclass = information.getSuperResourceType();
        if (superclass == null) {
            return null;
        }
        boolean hasSuperType = this.resourceRegistry.hasEntry(superclass);
        return hasSuperType ? this.resourceRegistry.getEntry(superclass).getResourceInformation() : null;
    }

    public List<Resource> filterByType(Collection<Resource> resources, ResourceInformation resourceInformation) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (!this.isInstance(resourceInformation, resource)) continue;
            results.add(resource);
        }
        return results;
    }

    private boolean isInstance(ResourceInformation desiredResourceInformation, Resource resource) {
        ResourceInformation actualResourceInformation;
        if (desiredResourceInformation.getResourceType().equals(resource.getType())) {
            return true;
        }
        ResourceInformation superInformation = actualResourceInformation = this.resourceRegistry.getEntry(resource.getType()).getResourceInformation();
        while ((superInformation = this.getSuperInformation(superInformation)) != null) {
            if (!superInformation.equals(desiredResourceInformation)) continue;
            return true;
        }
        return false;
    }

    public boolean isInclusionRequested(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        if (queryAdapter.isEmpty() || queryAdapter.getIncludedRelations() == null || queryAdapter.getIncludedRelations() == null) {
            return false;
        }
        if (queryAdapter instanceof QuerySpecAdapter) {
            return this.isInclusionRequestedForQueryspec(queryAdapter, fieldPath);
        }
        return this.isInclusionRequestedForQueryParams(queryAdapter, fieldPath);
    }

    private boolean isInclusionRequestedForQueryspec(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        QuerySpec querySpec = ((QuerySpecAdapter)queryAdapter).getQuerySpec();
        if (this.includeBehavior == IncludeBehavior.PER_ROOT_PATH) {
            return this.contains(querySpec, this.toPathList(fieldPath, 0));
        }
        for (int i = fieldPath.size() - 1; i >= 0; --i) {
            List<String> path = this.toPathList(fieldPath, i);
            ResourceInformation rootInformation = fieldPath.get(i).getResourceInformation();
            QuerySpec rootQuerySpec = querySpec.getQuerySpec(rootInformation);
            if (rootQuerySpec == null || !this.contains(rootQuerySpec, path)) continue;
            return true;
        }
        return this.contains(querySpec, this.toPathList(fieldPath, 0));
    }

    private boolean isInclusionRequestedForQueryParams(QueryAdapter queryAdapter, List<ResourceField> fieldPath) {
        Map<String, Set<PathSpec>> params = queryAdapter.getIncludedRelations();
        for (int i = fieldPath.size() - 1; i >= 0; --i) {
            String path = this.toPath(fieldPath, i);
            ResourceInformation rootInformation = fieldPath.get(i).getResourceInformation();
            Set<PathSpec> includedRelationsParams = params.get(rootInformation.getResourceType());
            if (includedRelationsParams == null || !this.contains(includedRelationsParams, path)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Set<PathSpec> includedRelationsParams, String path) {
        String pathPrefix = path + ".";
        for (PathSpec inclusion : includedRelationsParams) {
            if (!inclusion.toString().equals(path) && !inclusion.toString().startsWith(pathPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(QuerySpec querySpec, List<String> path) {
        for (IncludeRelationSpec inclusion : querySpec.getIncludedRelations()) {
            if (!inclusion.getAttributePath().equals(path) && !this.startsWith(inclusion, path)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(IncludeRelationSpec inclusion, List<String> path) {
        return inclusion.getAttributePath().size() > path.size() && inclusion.getAttributePath().subList(0, path.size()).equals(path);
    }

    private String toPath(List<ResourceField> fieldPath, int offset) {
        StringBuilder builder = new StringBuilder();
        for (int i = offset; i < fieldPath.size(); ++i) {
            ResourceField field = fieldPath.get(i);
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(field.getUnderlyingName());
        }
        return builder.toString();
    }

    private List<String> toPathList(List<ResourceField> fieldPath, int offset) {
        ArrayList<String> builder;
        ArrayList<String> result = builder = new ArrayList<String>();
        for (int i = offset; i < fieldPath.size(); ++i) {
            ResourceField field = fieldPath.get(i);
            result.add(field.getUnderlyingName());
        }
        return result;
    }

    public List<Resource> sub(Collection<Resource> resourcesWithField, Collection<Resource> resourcesForLookup) {
        ArrayList<Resource> result = new ArrayList<Resource>(resourcesWithField);
        result.removeAll(resourcesForLookup);
        return result;
    }

    public List<Resource> filterByLoadedRelationship(List<Resource> resources, ResourceField resourceField) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (resource.getRelationships().get(resourceField.getJsonName()) == null) continue;
            results.add(resource);
        }
        return results;
    }

    public Set<ResourceIdentifier> toIds(Set<Resource> resources) {
        HashSet<ResourceIdentifier> results = new HashSet<ResourceIdentifier>();
        for (Resource resource : resources) {
            results.add(resource.toIdentifier());
        }
        return results;
    }

    public List<ResourceIdentifier> toIds(List<Resource> resources) {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (Resource resource : resources) {
            results.add(resource.toIdentifier());
        }
        return results;
    }

    public Set<Resource> union(Collection<Resource> set0, Collection<Resource> set1) {
        HashMap<ResourceIdentifier, Resource> map = new HashMap<ResourceIdentifier, Resource>();
        for (Resource resource : set0) {
            map.put(resource.toIdentifier(), resource);
        }
        for (Resource resource : set1) {
            map.put(resource.toIdentifier(), resource);
        }
        return new HashSet<Resource>(map.values());
    }

    public List<Resource> findResourcesWithoutRelationshipToLoad(List<Resource> resources, ResourceField resourceField, IncludeRequest includeRequest) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource resource : resources) {
            Relationship relationship = resource.getRelationships().get(resourceField.getJsonName());
            if (relationship.getData().isPresent() && this.isLoaded(relationship, includeRequest)) continue;
            results.add(resource);
        }
        return results;
    }

    private boolean isLoaded(Relationship relationship, IncludeRequest includeRequest) {
        for (ResourceIdentifier id : relationship.getCollectionData().get()) {
            if (includeRequest.containsResource(id)) continue;
            return false;
        }
        return true;
    }

    public ResourceIdentifier idToResourceId(ResourceInformation resourceInformation, Object objectId) {
        if (objectId == null) {
            return null;
        }
        if (objectId instanceof ResourceIdentifier) {
            return (ResourceIdentifier)objectId;
        }
        String strId = resourceInformation.toIdString(objectId);
        return new ResourceIdentifier(strId, resourceInformation.getResourceType());
    }
}

