/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.AnyResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.ResourceMappingConfig;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.resource.annotations.JsonIncludeStrategy;
import io.crnk.core.resource.links.Link;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.meta.MetaInformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceMapper.class);
    private static final String SELF_FIELD_NAME = "self";
    private final String RELATED_FIELD_NAME = "related";
    private final ResourceFilterDirectory resourceFilterDirectory;
    private DocumentMapperUtil util;
    private boolean client;
    private ObjectMapper objectMapper;
    private static Set<Object> defaultValues = new HashSet<Number>(Arrays.asList((byte)0, (short)0, 0, 0L, Float.valueOf(0.0f), 0.0));

    public ResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper, ResourceFilterDirectory resourceFilterDirectory) {
        this.util = util;
        this.client = client;
        this.objectMapper = objectMapper;
        this.resourceFilterDirectory = resourceFilterDirectory;
    }

    public Resource toData(Object entity, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        if (entity instanceof Resource) {
            Resource resource = (Resource)entity;
            LOGGER.debug("directly returning id={}, type={}", (Object)resource.getId(), (Object)resource.getType());
            return resource;
        }
        QueryContext queryContext = queryAdapter.getQueryContext();
        ResourceInformation resourceInformation = this.util.getResourceInformation(entity);
        Resource resource = new Resource();
        this.setId(resource, entity, resourceInformation);
        resource.setType(resourceInformation.getResourceType());
        LOGGER.debug("mapping id={}, type={}", (Object)resource.getId(), (Object)resource.getType());
        if (mappingConfig.getSerializeLinks()) {
            this.util.setLinks(resource, this.getResourceLinks(entity, resourceInformation, queryContext), queryAdapter);
        }
        this.util.setMeta(resource, this.getResourceMeta(entity, resourceInformation));
        this.setAttributes(resource, entity, resourceInformation, queryAdapter, mappingConfig);
        this.setRelationships(resource, entity, resourceInformation, queryAdapter, mappingConfig);
        return resource;
    }

    private void setId(Resource resource, Object entity, ResourceInformation resourceInformation) {
        Object value;
        ResourceField idField = resourceInformation.getIdField();
        if (this.isValueIncluded(idField, value = idField.getAccessor().getValue(entity))) {
            resource.setId(resourceInformation.toIdString(value));
        }
    }

    private MetaInformation getResourceMeta(Object entity, ResourceInformation resourceInformation) {
        if (resourceInformation.getMetaField() != null) {
            return (MetaInformation)resourceInformation.getMetaField().getAccessor().getValue(entity);
        }
        return null;
    }

    public LinksInformation getResourceLinks(Object entity, ResourceInformation resourceInformation, QueryContext queryContext) {
        SelfLinksInformation self;
        LinksInformation info = resourceInformation.getLinksField() != null ? (LinksInformation)resourceInformation.getLinksField().getAccessor().getValue(entity) : new DocumentMapperUtil.DefaultSelfRelatedLinksInformation();
        if (info instanceof SelfLinksInformation && (self = (SelfLinksInformation)info).getSelf() == null && !this.client) {
            self.setSelf(this.util.getSelfUrl(queryContext, resourceInformation, entity));
        }
        return info;
    }

    protected void setAttributes(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getAttributeFields(), false);
        QueryContext queryContext = queryAdapter.getQueryContext();
        for (ResourceField field : fields) {
            if (!this.isIgnored(field, queryContext) && field.getAccess().isReadable()) {
                Object value = field.getAccessor().getValue(entity);
                if (!mappingConfig.isIgnoreDefaults() || !this.isDefaultValue(value)) {
                    LOGGER.debug("setting {}={}", (Object)field.getUnderlyingName(), value);
                    this.setAttribute(resource, field, value);
                    continue;
                }
                LOGGER.debug("ignored default value for {}", (Object)field.getUnderlyingName());
                continue;
            }
            LOGGER.debug("ignored {} due to filter", (Object)field.getUnderlyingName());
        }
        if (resourceInformation.getAnyFieldAccessor() != null) {
            AnyResourceFieldAccessor anyFieldAccessor = resourceInformation.getAnyFieldAccessor();
            Map<String, Object> map = anyFieldAccessor.getValues(entity);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.setAnyAttribute(resource, entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean isDefaultValue(Object value) {
        return value == null || defaultValues.contains(value) || value instanceof Collection && ((Collection)value).isEmpty();
    }

    protected boolean isIgnored(ResourceField field, QueryContext queryContext) {
        return this.resourceFilterDirectory != null && this.resourceFilterDirectory.get(field, HttpMethod.GET, queryContext) != FilterBehavior.NONE;
    }

    protected void setAttribute(Resource resource, ResourceField field, Object value) {
        JsonNode valueNode;
        if (this.isValueIncluded(field, value) && this.isNodeIncluded(field, valueNode = this.objectMapper.valueToTree(value))) {
            resource.getAttributes().put(field.getJsonName(), valueNode);
        }
    }

    protected void setAnyAttribute(Resource resource, String field, Object value) {
        JsonNode valueNode = this.objectMapper.valueToTree(value);
        resource.getAttributes().put(field, valueNode);
    }

    private boolean isNodeIncluded(ResourceField field, JsonNode node) {
        JsonIncludeStrategy includeStrategy = field.getJsonIncludeStrategy();
        return JsonIncludeStrategy.DEFAULT.equals((Object)includeStrategy) || !this.isNullNodeValue(node) && JsonIncludeStrategy.NOT_NULL.equals((Object)includeStrategy) || !this.isDefaultNodeValue(node) && JsonIncludeStrategy.NON_EMPTY.equals((Object)includeStrategy);
    }

    protected boolean isDefaultNodeValue(JsonNode node) {
        return this.isNullNodeValue(node) || (node.isObject() || node.isArray()) && node.size() == 0 || node.asText().isEmpty() || node.isNumber() && node.asDouble() == 0.0;
    }

    protected boolean isNullNodeValue(JsonNode node) {
        return node == null || node.isNull();
    }

    private boolean isValueIncluded(ResourceField field, Object value) {
        JsonIncludeStrategy includeStrategy = field.getJsonIncludeStrategy();
        return JsonIncludeStrategy.DEFAULT.equals((Object)includeStrategy) || value != null && JsonIncludeStrategy.NOT_NULL.equals((Object)includeStrategy) || JsonIncludeStrategy.NON_EMPTY.equals((Object)includeStrategy) && !this.isDefaultValue(value);
    }

    protected void setRelationships(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getRelationshipFields(), true);
        QueryContext queryContext = queryAdapter.getQueryContext();
        for (ResourceField field : fields) {
            if (this.isIgnored(field, queryContext)) continue;
            this.setRelationship(resource, field, entity, resourceInformation, queryAdapter, mappingConfig);
        }
    }

    protected void setRelationship(Resource resource, ResourceField field, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        boolean addRelationship;
        SerializerUtil serializerUtil = DocumentMapperUtil.getSerializerUtil();
        Relationship relationship = new Relationship();
        boolean bl = addRelationship = mappingConfig.getSerializeLinks() && (queryAdapter == null || !queryAdapter.getCompactMode());
        if (addRelationship) {
            Link relatedLink;
            Link selfLink;
            ObjectNode relationshipLinks = this.objectMapper.createObjectNode();
            if (mappingConfig.getSerializeSelfRelationshipLinks() && (selfLink = this.util.getRelationshipLink(resource, field, false)) != null) {
                serializerUtil.serializeLink(this.objectMapper, relationshipLinks, SELF_FIELD_NAME, selfLink);
            }
            if ((relatedLink = this.util.getRelationshipLink(resource, field, true)) != null) {
                serializerUtil.serializeLink(this.objectMapper, relationshipLinks, "related", relatedLink);
                relationship.setLinks(relationshipLinks);
            }
        }
        resource.getRelationships().put(field.getJsonName(), relationship);
    }
}

