/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

public class AnnotatedClassBuilder {
    private static final String CONSTRUCT_METHOD_NAME = "construct";
    private static final String CANNOT_FIND_PROPER_METHOD = "Couldn't find proper AnnotatedClass#construct method";

    private AnnotatedClassBuilder() {
    }

    public static AnnotatedClass build(final Class<?> declaringClass, final SerializationConfig serializationConfig) {
        for (final Method method : AnnotatedClass.class.getMethods()) {
            if (!CONSTRUCT_METHOD_NAME.equals(method.getName()) || method.getParameterTypes().length != 3) continue;
            return ExceptionUtil.wrapCatchedExceptions(new Callable<AnnotatedClass>(){

                @Override
                public AnnotatedClass call() throws Exception {
                    return AnnotatedClassBuilder.buildAnnotatedClass(method, declaringClass, serializationConfig);
                }
            }, "Exception while building AnnotatedClass", new Object[0]);
        }
        throw new IllegalStateException(CANNOT_FIND_PROPER_METHOD);
    }

    private static AnnotatedClass buildAnnotatedClass(Method method, Class<?> declaringClass, SerializationConfig serializationConfig) throws InvocationTargetException, IllegalAccessException {
        if (method.getParameterTypes()[0] == Class.class) {
            return AnnotatedClassBuilder.buildOldAnnotatedClass(method, declaringClass, serializationConfig);
        }
        PreconditionUtil.verifyEquals(method.getParameterTypes()[0], JavaType.class, "unexpected method signature for %d", method);
        return AnnotatedClassBuilder.buildNewAnnotatedClass(method, declaringClass, serializationConfig);
    }

    private static AnnotatedClass buildNewAnnotatedClass(Method method, Class<?> declaringClass, SerializationConfig serializationConfig) throws InvocationTargetException, IllegalAccessException {
        JavaType declaringType = serializationConfig.constructType(declaringClass);
        return (AnnotatedClass)method.invoke(null, declaringType, serializationConfig, serializationConfig);
    }

    private static AnnotatedClass buildOldAnnotatedClass(Method method, Class<?> declaringClass, SerializationConfig serializationConfig) throws InvocationTargetException, IllegalAccessException {
        boolean useAnnotations = serializationConfig.isAnnotationProcessingEnabled();
        AnnotationIntrospector aintr = useAnnotations ? serializationConfig.getAnnotationIntrospector() : null;
        return (AnnotatedClass)method.invoke(null, declaringClass, aintr, serializationConfig);
    }
}

