/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

public class AnnotatedFieldBuilder {
    private static final String CANNOT_FIND_PROPER_CONSTRUCTOR = "Couldn't find proper AnnotatedField constructor";

    private AnnotatedFieldBuilder() {
    }

    public static AnnotatedField build(final AnnotatedClass annotatedClass, final Field field, final AnnotationMap annotationMap) {
        final Constructor<?> constructor = AnnotatedField.class.getConstructors()[0];
        return ExceptionUtil.wrapCatchedExceptions(new Callable<AnnotatedField>(){

            @Override
            public AnnotatedField call() throws Exception {
                return AnnotatedFieldBuilder.buildAnnotatedField(annotatedClass, field, annotationMap, constructor);
            }
        }, "Exception while building AnnotatedField", new Object[0]);
    }

    private static AnnotatedField buildAnnotatedField(AnnotatedClass annotatedClass, Field field, AnnotationMap annotationMap, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> firstParameterType = constructor.getParameterTypes()[0];
        PreconditionUtil.verify(firstParameterType == AnnotatedClass.class || TypeResolutionContext.class.equals(firstParameterType), CANNOT_FIND_PROPER_CONSTRUCTOR, new Object[0]);
        return (AnnotatedField)constructor.newInstance(annotatedClass, field, annotationMap);
    }
}

