/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.BeanInformationBase;
import io.crnk.core.engine.information.resource.EmbeddableInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.VersionRange;
import io.crnk.core.engine.internal.information.resource.RawResourceFieldAccessor;
import io.crnk.core.engine.internal.information.resource.ReflectionFieldAccessor;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.JsonIncludeStrategy;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.PatchStrategy;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ResourceFieldImpl
implements ResourceField {
    private String jsonName;
    private final String underlyingName;
    private final Class<?> type;
    private final Type genericType;
    private final SerializeType serializeType;
    private final JsonIncludeStrategy jsonIncludeStrategy;
    private final String oppositeResourceType;
    private LookupIncludeBehavior lookupIncludeBehavior;
    private ResourceFieldType resourceFieldType;
    private String oppositeName;
    private RelationshipRepositoryBehavior relationshipRepositoryBehavior;
    private BeanInformationBase parentInformation;
    private ResourceFieldAccessor accessor;
    private ResourceFieldAccess access;
    private String idName;
    private ResourceFieldAccessor idAccessor;
    private Class idType;
    private PatchStrategy patchStrategy;
    private boolean mappedBy;
    private VersionRange versionRange = VersionRange.UNBOUNDED;
    private EmbeddableInformation embeddedType;

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType) {
        this(jsonName, underlyingName, resourceFieldType, type, genericType, oppositeResourceType, null, SerializeType.LAZY, JsonIncludeStrategy.DEFAULT, LookupIncludeBehavior.NONE, new ResourceFieldAccess(true, true, true, true, true, true), null, null, null, RelationshipRepositoryBehavior.DEFAULT, PatchStrategy.DEFAULT);
    }

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType, String oppositeName, SerializeType serializeType, JsonIncludeStrategy jsonIncludeStrategy, LookupIncludeBehavior lookupIncludeBehavior, ResourceFieldAccess access, String idName, Class idType, ResourceFieldAccessor idAccessor, RelationshipRepositoryBehavior relationshipRepositoryBehavior, PatchStrategy patchStrategy) {
        this.jsonName = jsonName;
        this.underlyingName = underlyingName;
        this.resourceFieldType = resourceFieldType;
        this.serializeType = serializeType;
        this.jsonIncludeStrategy = jsonIncludeStrategy;
        this.type = type;
        this.genericType = genericType;
        this.lookupIncludeBehavior = lookupIncludeBehavior;
        this.oppositeName = oppositeName;
        this.oppositeResourceType = oppositeResourceType;
        this.access = access;
        this.idName = idName;
        this.idType = idType;
        this.idAccessor = idAccessor;
        this.relationshipRepositoryBehavior = relationshipRepositoryBehavior;
        this.patchStrategy = patchStrategy;
        PreconditionUtil.assertEquals("expected generic type to match", ClassUtils.getRawType(genericType), type);
        if (resourceFieldType != ResourceFieldType.LINKS_INFORMATION) {
            PreconditionUtil.verify(!jsonName.equals("links"), "cannot name none-@JsonLinksInformation field `links`", new Object[0]);
        }
        if (resourceFieldType != ResourceFieldType.META_INFORMATION) {
            PreconditionUtil.verify(!jsonName.equals("meta"), "cannot name none-@JsonMetanformation field `meta`", new Object[0]);
        }
    }

    public void setMappedBy(boolean mappedBy) {
        this.mappedBy = mappedBy;
    }

    @Deprecated
    public void setJsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    @Deprecated
    public void setResourceFieldType(ResourceFieldType resourceFieldType) {
        this.resourceFieldType = resourceFieldType;
    }

    @Override
    public ResourceFieldType getResourceFieldType() {
        return this.resourceFieldType;
    }

    @Override
    public boolean isMappedBy() {
        return this.mappedBy;
    }

    @Override
    public RelationshipRepositoryBehavior getRelationshipRepositoryBehavior() {
        return this.relationshipRepositoryBehavior;
    }

    @Override
    public LookupIncludeBehavior getLookupIncludeBehavior() {
        return this.lookupIncludeBehavior;
    }

    @Override
    public String getOppositeName() {
        return this.oppositeName;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public String getOppositeResourceType() {
        PreconditionUtil.verifyEquals((Object)ResourceFieldType.RELATIONSHIP, (Object)this.resourceFieldType, "field %s of %s is not an association", this.underlyingName, this.parentInformation);
        if (this.getElementType() != Object.class) {
            PreconditionUtil.verify(this.oppositeResourceType != null, "field %s of %s does not have an opposite resource type", this.underlyingName, this.parentInformation);
        }
        return this.oppositeResourceType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public SerializeType getSerializeType() {
        return this.serializeType;
    }

    @Override
    public JsonIncludeStrategy getJsonIncludeStrategy() {
        return this.jsonIncludeStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldImpl that = (ResourceFieldImpl)o;
        return Objects.equals(this.underlyingName, that.underlyingName) && this.parentInformation == that.parentInformation;
    }

    public int hashCode() {
        return Objects.hash(this.underlyingName, this.parentInformation);
    }

    @Override
    public Class<?> getElementType() {
        return ClassUtils.getRawType(ClassUtils.getElementType(this.genericType));
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return (ResourceInformation)this.parentInformation;
    }

    @Override
    public BeanInformationBase getParentInformation() {
        return this.parentInformation;
    }

    @Override
    public ResourceFieldAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public boolean hasIdField() {
        this.assertRelationship();
        return this.idName != null;
    }

    @Override
    public String getIdName() {
        return this.idName;
    }

    @Override
    public Class getIdType() {
        this.assertRelationship();
        return this.idType;
    }

    @Override
    public ResourceFieldAccessor getIdAccessor() {
        this.assertRelationship();
        return this.idAccessor;
    }

    public void setIdField(String idName, Class idType, ResourceFieldAccessor idAccessor) {
        this.assertRelationship();
        this.idName = idName;
        this.idType = idType;
        this.idAccessor = idAccessor;
    }

    private void assertRelationship() {
        PreconditionUtil.assertEquals("not available for non-relationship fields", (Object)ResourceFieldType.RELATIONSHIP, (Object)this.getResourceFieldType());
    }

    public void setAccessor(ResourceFieldAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void setResourceInformation(BeanInformationBase resourceInformation) {
        if (this.accessor == null && resourceInformation.getImplementationClass() == Resource.class) {
            this.accessor = new RawResourceFieldAccessor(this.underlyingName, this.resourceFieldType, this.type);
        } else if (this.accessor == null) {
            this.accessor = new ReflectionFieldAccessor(resourceInformation.getImplementationClass(), this.underlyingName, this.type);
        }
        if (this.idAccessor == null && this.idName != null) {
            this.idAccessor = new ReflectionFieldAccessor(resourceInformation.getImplementationClass(), this.idName, this.idType);
            if (this.idType == ResourceIdentifier.class) {
                this.idAccessor = new ResourceIdentifierAccessorAdapter(this.idAccessor);
            }
        }
        if (resourceInformation instanceof ResourceInformation) {
            this.parentInformation = (ResourceInformation)resourceInformation;
            PreconditionUtil.verify(!this.jsonName.equals("id") || this.resourceFieldType == ResourceFieldType.ID, "only ID fields can be named 'id' for %s, consider adding @JsonApiId, ignoring it with @JsonIgnore or renaming it with @JsonProperty", resourceInformation);
        }
    }

    public void setRelationshipRepositoryBehavior(RelationshipRepositoryBehavior relationshipRepositoryBehavior) {
        this.relationshipRepositoryBehavior = relationshipRepositoryBehavior;
    }

    public void setLookupIncludeBehavior(LookupIncludeBehavior behavior) {
        this.lookupIncludeBehavior = behavior;
    }

    public void setOppositeName(String oppositeName) {
        this.oppositeName = oppositeName;
    }

    public void setAccess(ResourceFieldAccess access) {
        this.access = access;
    }

    public void setEmbeddedType(EmbeddableInformation embeddedType) {
        this.embeddedType = embeddedType;
    }

    @Override
    public EmbeddableInformation getEmbeddedType() {
        return this.embeddedType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.parentInformation != null && this.parentInformation.getImplementationClass() != null) {
            sb.append("resourceClass=").append(this.parentInformation.getImplementationClass().getName());
        }
        sb.append(", name=").append(this.underlyingName);
        if (this.parentInformation instanceof ResourceInformation && this.getResourceInformation().getResourceType() != null) {
            sb.append(",resourceType=").append(this.getResourceInformation().getResourceType());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.getType());
    }

    @Override
    public ResourceFieldAccess getAccess() {
        return this.access;
    }

    @Override
    public PatchStrategy getPatchStrategy() {
        return this.patchStrategy;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    class ResourceIdentifierAccessorAdapter
    extends ResourceFieldAccessorWrapper {
        public ResourceIdentifierAccessorAdapter(ResourceFieldAccessor idAccessor) {
            super(idAccessor);
        }

        @Override
        public void setValue(Object resource, Object fieldValue) {
            if (fieldValue == null || fieldValue instanceof ResourceIdentifier) {
                super.setValue(resource, fieldValue);
            } else {
                super.setValue(resource, new ResourceIdentifier(fieldValue.toString(), ResourceFieldImpl.this.oppositeResourceType));
            }
        }
    }

    static class ResourceFieldAccessorWrapper
    implements ResourceFieldAccessor {
        protected final ResourceFieldAccessor wrappedAccessor;

        public ResourceFieldAccessorWrapper(ResourceFieldAccessor wrappedAccessor) {
            this.wrappedAccessor = wrappedAccessor;
        }

        @Override
        public Object getValue(Object resource) {
            return this.wrappedAccessor.getValue(resource);
        }

        @Override
        public void setValue(Object resource, Object fieldValue) {
            this.wrappedAccessor.setValue(resource, fieldValue);
        }

        @Override
        public Class getImplementationClass() {
            return this.wrappedAccessor.getImplementationClass();
        }
    }
}

