/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProvider;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.information.resource.VersionRange;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupUtil;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.FieldOrderedComparator;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiRelationId;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.JsonApiVersion;
import io.crnk.core.resource.annotations.JsonIncludeStrategy;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.PatchStrategy;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceInformationProviderBase
implements ResourceInformationProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected ResourceInformationProviderContext context;
    protected List<ResourceFieldInformationProvider> resourceFieldInformationProviders;
    private LookupIncludeBehavior globalLookupIncludeBehavior;
    private boolean enforceIdName;

    public ResourceInformationProviderBase(PropertiesProvider propertiesProvider, List<ResourceFieldInformationProvider> resourceFieldInformationProviders) {
        this.resourceFieldInformationProviders = resourceFieldInformationProviders;
        this.globalLookupIncludeBehavior = IncludeLookupUtil.getGlobalLookupIncludeBehavior(propertiesProvider);
        String strEnforceIdName = propertiesProvider.getProperty("crnk.enforceIdName");
        this.enforceIdName = strEnforceIdName == null || Boolean.parseBoolean(strEnforceIdName);
    }

    protected VersionRange getVersionRange(Class<?> resourceClass) {
        JsonApiVersion annotation = resourceClass.getAnnotation(JsonApiVersion.class);
        if (annotation != null) {
            return VersionRange.of(annotation.min(), annotation.max());
        }
        return VersionRange.UNBOUNDED;
    }

    @Override
    public void init(ResourceInformationProviderContext context) {
        this.context = context;
        for (ResourceFieldInformationProvider resourceFieldInformationProvider : this.resourceFieldInformationProviders) {
            resourceFieldInformationProvider.init(context);
        }
    }

    protected ResourceFieldAccess getResourceAccess(Class<?> resourceClass) {
        boolean sortable = true;
        boolean filterable = true;
        boolean postable = true;
        boolean deletable = true;
        boolean patchable = true;
        boolean readable = true;
        JsonApiResource annotation = resourceClass.getAnnotation(JsonApiResource.class);
        if (annotation != null) {
            sortable = annotation.sortable();
            filterable = annotation.filterable();
            postable = annotation.postable();
            deletable = annotation.deletable();
            patchable = annotation.patchable();
            readable = annotation.readable();
        }
        return new ResourceFieldAccess(readable, postable, patchable, deletable, sortable, filterable);
    }

    protected List<ResourceField> getResourceFields(Class<?> resourceClass, ResourceFieldAccess resourceAccess, boolean embedded) {
        BeanInformation beanDesc = BeanInformation.get(resourceClass);
        List<String> attributeNames = beanDesc.getAttributeNames();
        ArrayList<ResourceField> fields = new ArrayList<ResourceField>();
        HashSet<String> relationIdFields = new HashSet<String>();
        for (String attributeName : attributeNames) {
            BeanAttributeInformation attributeDesc = beanDesc.getAttribute(attributeName);
            if (!this.isIgnored(attributeDesc)) {
                InformationBuilder informationBuilder = this.context.getInformationBuilder();
                InformationBuilder.FieldInformationBuilder fieldBuilder = informationBuilder.createResourceField();
                this.buildResourceField(beanDesc, embedded, attributeDesc, fieldBuilder);
                fields.add(fieldBuilder.build());
                continue;
            }
            if (!attributeDesc.getAnnotation(JsonApiRelationId.class).isPresent()) continue;
            relationIdFields.add(attributeDesc.getName());
        }
        if (!embedded) {
            this.verifyRelationIdFields(resourceClass, relationIdFields, fields);
        }
        for (ResourceField resourceField : fields) {
            ResourceFieldImpl impl = (ResourceFieldImpl)resourceField;
            impl.setAccess(impl.getAccess().and(resourceAccess));
        }
        Optional<JsonPropertyOrder> propertyOrder = ClassUtils.getAnnotation(resourceClass, JsonPropertyOrder.class);
        if (propertyOrder.isPresent()) {
            JsonPropertyOrder propertyOrderAnnotation = propertyOrder.get();
            Collections.sort(fields, new FieldOrderedComparator(propertyOrderAnnotation.value(), propertyOrderAnnotation.alphabetic()));
        }
        return fields;
    }

    private void verifyRelationIdFields(Class resourceClass, Set<String> relationIdFields, List<ResourceField> fields) {
        for (ResourceField field : fields) {
            if (field.getResourceFieldType() != ResourceFieldType.RELATIONSHIP || !field.hasIdField()) continue;
            relationIdFields.remove(field.getIdName());
        }
        if (!relationIdFields.isEmpty()) {
            throw new InvalidResourceException(resourceClass.getName() + " annotated " + relationIdFields + " with @JsonApiRelationId but no matching relationship found");
        }
    }

    protected void buildResourceField(BeanInformation beanDesc, boolean embedded, BeanAttributeInformation attributeDesc, InformationBuilder.FieldInformationBuilder fieldBuilder) {
        Type genericType;
        fieldBuilder.underlyingName(attributeDesc.getName());
        ResourceFieldType fieldType = this.getFieldType(attributeDesc, embedded);
        fieldBuilder.jsonName(this.getJsonName(attributeDesc, fieldType));
        ResourceFieldAccess access = this.getAccess(attributeDesc, fieldType);
        fieldBuilder.fieldType(fieldType);
        fieldBuilder.access(access);
        fieldBuilder.patchStrategy(this.getPatchStrategy(attributeDesc));
        fieldBuilder.jsonIncludeStrategy(this.getJsonIncludeStrategy(attributeDesc));
        fieldBuilder.serializeType(this.getSerializeType(attributeDesc, fieldType));
        fieldBuilder.relationshipRepositoryBehavior(this.getRelationshipRepositoryBehavior(attributeDesc));
        fieldBuilder.versionRange(this.getVersionRange(attributeDesc));
        if (this.useFieldType(attributeDesc)) {
            fieldBuilder.type(attributeDesc.getField().getType());
            genericType = attributeDesc.getField().getGenericType();
        } else {
            fieldBuilder.type(attributeDesc.getGetter().getReturnType());
            genericType = attributeDesc.getGetter().getGenericReturnType();
        }
        fieldBuilder.genericType(genericType);
        if (fieldType == ResourceFieldType.RELATIONSHIP) {
            String idFieldNameTemp;
            BeanAttributeInformation idAttributeTemp;
            Optional<String> mappedBy = this.getMappedBy(attributeDesc);
            if (mappedBy.isPresent() && !mappedBy.get().isEmpty()) {
                fieldBuilder.setMappedBy(true);
            }
            fieldBuilder.oppositeResourceType(ResourceInformationProviderBase.getResourceType(genericType, this.context));
            fieldBuilder.oppositeName(this.getOppositeName(attributeDesc));
            Optional<JsonApiRelation> relationAnnotation = attributeDesc.getAnnotation(JsonApiRelation.class);
            boolean multiValued = Collection.class.isAssignableFrom(attributeDesc.getImplementationClass());
            String suffix = multiValued ? "Ids" : "Id";
            boolean hasIdNameReference = relationAnnotation.isPresent() && relationAnnotation.get().idField().length() > 0;
            String idFieldName = hasIdNameReference ? relationAnnotation.get().idField() : attributeDesc.getName() + suffix;
            BeanAttributeInformation idAttribute = beanDesc.getAttribute(idFieldName);
            if (idAttribute == null && multiValued && attributeDesc.getName().endsWith("s") && (idAttributeTemp = beanDesc.getAttribute(idFieldNameTemp = attributeDesc.getName().substring(0, attributeDesc.getName().length() - 1) + suffix)) != null && attributeDesc.getGetter() != null && idAttributeTemp.getGetter().getReturnType().equals(attributeDesc.getGetter().getReturnType())) {
                idFieldName = idFieldNameTemp;
                idAttribute = idAttributeTemp;
            }
            PreconditionUtil.verify(idAttribute != null || !hasIdNameReference, "idField %s not found for %s", idFieldName, attributeDesc);
            if (idAttribute != null && (hasIdNameReference || idAttribute.getAnnotation(JsonApiRelationId.class).isPresent())) {
                fieldBuilder.idName(idFieldName);
                fieldBuilder.idType(idAttribute.getImplementationClass());
            }
            fieldBuilder.lookupIncludeBehavior(this.getLookupIncludeBehavior(attributeDesc, idAttribute != null));
        }
        if (this.isEmbeddedType(attributeDesc)) {
            Class<?> elementType = ClassUtils.getRawType(ClassUtils.getElementType(attributeDesc.getImplementationType()));
            InformationBuilder.EmbeddableInformationBuilder embBuilder = fieldBuilder.embeddedType(elementType);
            List<ResourceField> embFields = this.getResourceFields(elementType, access, true);
            embFields.forEach(field -> embBuilder.addField().from((ResourceField)field));
        }
    }

    protected VersionRange getVersionRange(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<VersionRange> versionRange = fieldInformationProvider.getVersionRange(attributeDesc);
            if (!versionRange.isPresent()) continue;
            return versionRange.get();
        }
        return VersionRange.UNBOUNDED;
    }

    protected RelationshipRepositoryBehavior getRelationshipRepositoryBehavior(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<RelationshipRepositoryBehavior> behavior = fieldInformationProvider.getRelationshipRepositoryBehavior(attributeDesc);
            if (!behavior.isPresent()) continue;
            return behavior.get();
        }
        return this.getDefaultRelationshipRepositoryBehavior(attributeDesc);
    }

    protected Optional<String> getMappedBy(BeanAttributeInformation attributeDesc) {
        Optional<String> mappedBy = Optional.empty();
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<String> opt = fieldInformationProvider.getMappedBy(attributeDesc);
            if (!opt.isPresent() || mappedBy.isPresent() && !mappedBy.get().isEmpty()) continue;
            mappedBy = opt;
        }
        return mappedBy;
    }

    protected RelationshipRepositoryBehavior getDefaultRelationshipRepositoryBehavior(BeanAttributeInformation attributeDesc) {
        return RelationshipRepositoryBehavior.DEFAULT;
    }

    private static String getResourceType(Type genericType, ResourceInformationProviderContext context) {
        Class<?> rawType;
        Class<?> elementType = genericType;
        if (Iterable.class.isAssignableFrom(ClassUtils.getRawType(genericType))) {
            elementType = ClassUtils.getRawType(((ParameterizedType)((Object)genericType)).getActualTypeArguments()[0]);
        }
        return context.accept(rawType = ClassUtils.getRawType(elementType)) ? context.getResourceType(rawType) : null;
    }

    private boolean useFieldType(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> jsonName = fieldInformationProvider.useFieldType(attributeDesc);
            if (!jsonName.isPresent()) continue;
            return jsonName.get();
        }
        return attributeDesc.getGetter() == null;
    }

    private SerializeType getSerializeType(BeanAttributeInformation attributeDesc, ResourceFieldType resourceFieldType) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<SerializeType> lazy = fieldInformationProvider.getSerializeType(attributeDesc);
            if (!lazy.isPresent()) continue;
            return lazy.get();
        }
        return resourceFieldType == ResourceFieldType.RELATIONSHIP ? SerializeType.LAZY : SerializeType.EAGER;
    }

    public JsonIncludeStrategy getJsonIncludeStrategy(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<JsonIncludeStrategy> jsonIncludeStrategy = fieldInformationProvider.getJsonIncludeStrategy(attributeDesc);
            if (!jsonIncludeStrategy.isPresent()) continue;
            return jsonIncludeStrategy.get();
        }
        if (attributeDesc.getImplementationClass() == Optional.class) {
            return JsonIncludeStrategy.NOT_NULL;
        }
        return JsonIncludeStrategy.DEFAULT;
    }

    protected boolean isEmbeddedType(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            if (!fieldInformationProvider.isEmbeddedType(attributeDesc)) continue;
            return true;
        }
        return false;
    }

    protected LookupIncludeBehavior getLookupIncludeBehavior(BeanAttributeInformation attributeDesc, boolean hasIdField) {
        LookupIncludeBehavior behavior = LookupIncludeBehavior.DEFAULT;
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<LookupIncludeBehavior> lookupIncludeBehavior = fieldInformationProvider.getLookupIncludeBehavior(attributeDesc);
            if (!lookupIncludeBehavior.isPresent()) continue;
            behavior = lookupIncludeBehavior.get();
            break;
        }
        if (behavior != LookupIncludeBehavior.DEFAULT) {
            this.LOGGER.debug("{}: using configured LookupIncludeBehavior.{}", (Object)attributeDesc, (Object)behavior);
            return behavior;
        }
        return this.getDefaultLookupIncludeBehavior(attributeDesc);
    }

    protected LookupIncludeBehavior getDefaultLookupIncludeBehavior(BeanAttributeInformation attributeDesc) {
        if (this.globalLookupIncludeBehavior != LookupIncludeBehavior.DEFAULT) {
            this.LOGGER.debug("{}: using global/configured default LookupIncludeBehavior.{}", (Object)attributeDesc, (Object)this.globalLookupIncludeBehavior);
            return this.globalLookupIncludeBehavior;
        }
        return LookupIncludeBehavior.DEFAULT;
    }

    private ResourceFieldAccess getAccess(BeanAttributeInformation attributeDesc, ResourceFieldType resourceFieldType) {
        boolean sortable = this.isSortable(attributeDesc);
        boolean filterable = this.isFilterable(attributeDesc);
        boolean postable = this.isPostable(attributeDesc);
        boolean deletable = this.isDeletable(attributeDesc);
        boolean patchable = this.isPatchable(attributeDesc, resourceFieldType);
        boolean readable = this.isReadable(attributeDesc);
        return new ResourceFieldAccess(readable, postable, patchable, deletable, sortable, filterable);
    }

    private boolean isSortable(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> sortable = fieldInformationProvider.isSortable(attributeDesc);
            if (!sortable.isPresent()) continue;
            return sortable.get();
        }
        return true;
    }

    private boolean isFilterable(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> filterable = fieldInformationProvider.isFilterable(attributeDesc);
            if (!filterable.isPresent()) continue;
            return filterable.get();
        }
        return true;
    }

    private boolean isPatchable(BeanAttributeInformation attributeDesc, ResourceFieldType resourceFieldType) {
        if (this.isReadOnly(attributeDesc) || resourceFieldType == ResourceFieldType.ID) {
            return false;
        }
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> patchable = fieldInformationProvider.isPatchable(attributeDesc);
            if (!patchable.isPresent()) continue;
            return patchable.get();
        }
        return true;
    }

    private boolean isPostable(BeanAttributeInformation attributeDesc) {
        if (this.isReadOnly(attributeDesc)) {
            return false;
        }
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> postable = fieldInformationProvider.isPostable(attributeDesc);
            if (!postable.isPresent()) continue;
            return postable.get();
        }
        return true;
    }

    private boolean isDeletable(BeanAttributeInformation attributeDesc) {
        if (this.isReadOnly(attributeDesc)) {
            return false;
        }
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> deletable = fieldInformationProvider.isDeletable(attributeDesc);
            if (!deletable.isPresent()) continue;
            return deletable.get();
        }
        return true;
    }

    private boolean isReadable(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> readable = fieldInformationProvider.isReadable(attributeDesc);
            if (!readable.isPresent()) continue;
            return readable.get();
        }
        return true;
    }

    private boolean isReadOnly(BeanAttributeInformation attributeDesc) {
        Field field = attributeDesc.getField();
        Method setter = attributeDesc.getSetter();
        return setter == null && (field == null || !Modifier.isPublic(field.getModifiers()));
    }

    private boolean isIgnored(BeanAttributeInformation attributeDesc) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<Boolean> ignored = fieldInformationProvider.isIgnored(attributeDesc);
            if (!ignored.isPresent()) continue;
            return ignored.get();
        }
        return false;
    }

    private PatchStrategy getPatchStrategy(BeanAttributeInformation attributeDesc) {
        PatchStrategy strategy = PatchStrategy.DEFAULT;
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<PatchStrategy> patchStrategy = fieldInformationProvider.getPatchStrategy(attributeDesc);
            if (!patchStrategy.isPresent()) continue;
            strategy = patchStrategy.get();
            break;
        }
        if (strategy == PatchStrategy.DEFAULT) {
            strategy = PatchStrategy.MERGE;
        }
        return strategy;
    }

    private ResourceFieldType getFieldType(BeanAttributeInformation attributeDesc, boolean embedded) {
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<ResourceFieldType> fieldType = fieldInformationProvider.getFieldType(attributeDesc);
            if (!fieldType.isPresent()) continue;
            ResourceFieldType type = fieldType.get();
            if (embedded && ResourceFieldType.RELATIONSHIP == type) {
                return ResourceFieldType.ATTRIBUTE;
            }
            return type;
        }
        return ResourceFieldType.ATTRIBUTE;
    }

    protected String getJsonName(BeanAttributeInformation attributeDesc, ResourceFieldType fieldType) {
        if (fieldType == ResourceFieldType.ID && this.enforceIdName) {
            return "id";
        }
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<String> jsonName = fieldInformationProvider.getJsonName(attributeDesc);
            if (!jsonName.isPresent()) continue;
            return jsonName.get();
        }
        return attributeDesc.getName();
    }

    private String getOppositeName(BeanAttributeInformation attributeDesc) {
        Optional<String> mappedBy = this.getMappedBy(attributeDesc);
        if (mappedBy.isPresent() && !mappedBy.get().isEmpty()) {
            return mappedBy.get();
        }
        for (ResourceFieldInformationProvider fieldInformationProvider : this.resourceFieldInformationProviders) {
            Optional<String> oppositeName = fieldInformationProvider.getOppositeName(attributeDesc);
            if (!oppositeName.isPresent()) continue;
            return oppositeName.get();
        }
        return null;
    }
}

