/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.resource.links.DefaultLink;
import io.crnk.core.resource.links.Link;
import io.crnk.core.resource.links.LinksInformation;
import java.io.IOException;

public class LinksInformationSerializer
extends JsonSerializer<LinksInformation> {
    private Boolean serializeLinksAsObjects;

    LinksInformationSerializer(Boolean serializeLinksAsObjects) {
        this.serializeLinksAsObjects = serializeLinksAsObjects;
    }

    public void serialize(LinksInformation value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        BeanInformation info = BeanInformation.get(value.getClass());
        for (String attrName : info.getAttributeNames()) {
            BeanAttributeInformation attribute = info.getAttribute(attrName);
            Object objLinkValue = attribute.getValue(value);
            String name = attribute.getJsonName();
            Link linkValue = objLinkValue instanceof String ? new DefaultLink((String)objLinkValue) : (Link)objLinkValue;
            if (linkValue == null) continue;
            if (!this.serializeLinksAsObjects.booleanValue() && !this.shouldSerializeLink(linkValue).booleanValue()) {
                gen.writeStringField(name, linkValue.getHref());
                continue;
            }
            gen.writeObjectField(name, (Object)linkValue);
        }
        gen.writeEndObject();
    }

    public Class<LinksInformation> handledType() {
        return LinksInformation.class;
    }

    private Boolean shouldSerializeLink(Link link) {
        return link.getRel() != null || link.getAnchor() != null || link.getParams() != null || link.getDescribedby() != null || link.getMeta() != null;
    }
}

