/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.ResourceRepositoryFacade;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.repository.ResourceRepository;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryEntryImpl
implements RegistryEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryEntryImpl.class);
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;
    private ResourceRepositoryAdapter resourceRepositoryAdapter;
    private Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapter;
    private PagingBehavior pagingBehavior;
    private ResourceInformation resourceInformation;

    public RegistryEntryImpl(ResourceInformation resourceInformation, ResourceRepositoryAdapter resourceRepositoryAdapter, Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapters, ModuleRegistry moduleRegistry) {
        this.resourceRepositoryAdapter = resourceRepositoryAdapter;
        this.relationshipRepositoryAdapter = relationshipRepositoryAdapters;
        this.moduleRegistry = moduleRegistry;
        this.resourceInformation = resourceInformation;
        PreconditionUtil.verify(resourceInformation != null, "resourceInformation must not be null", new Object[0]);
        PreconditionUtil.verify(moduleRegistry != null, "no moduleRegistry", new Object[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.resourceInformation.getResourceType() + ", path=" + this.resourceInformation.getResourcePath() + "]";
    }

    @Override
    public ResourceRepositoryAdapter getResourceRepository() {
        if (this.resourceRepositoryAdapter != null) {
            return this.resourceRepositoryAdapter;
        }
        RegistryEntry parentRegistryEntry = this.getParentRegistryEntry();
        return parentRegistryEntry.getResourceRepository();
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(String fieldName) {
        RegistryEntry parentRegistryEntry;
        ResourceField field = this.getResourceInformation().findFieldByUnderlyingName(fieldName);
        if (field == null && (parentRegistryEntry = this.getParentRegistryEntry()) != null) {
            return parentRegistryEntry.getRelationshipRepository(fieldName);
        }
        if (field == null) {
            throw new ResourceFieldNotFoundException("name=" + fieldName);
        }
        return this.getRelationshipRepository(field);
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(ResourceField field) {
        RegistryEntry parentRegistryEntry;
        RelationshipRepositoryAdapter adapter = this.relationshipRepositoryAdapter.get(field);
        if (adapter == null && (parentRegistryEntry = this.getParentRegistryEntry()) != null) {
            return parentRegistryEntry.getRelationshipRepository(field);
        }
        if (adapter == null) {
            throw new RelationshipRepositoryNotFoundException(field);
        }
        return adapter;
    }

    public void putRelationshipRepository(ResourceField field, RelationshipRepositoryAdapter adapter) {
        this.relationshipRepositoryAdapter.put(field, adapter);
    }

    public boolean hasRelationship(ResourceField field) {
        RegistryEntry parentRegistryEntry = this.getParentRegistryEntry();
        return this.relationshipRepositoryAdapter.containsKey(field) || parentRegistryEntry != null && ((RegistryEntryImpl)parentRegistryEntry).hasRelationship(field);
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceInformation;
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.resourceRepositoryAdapter != null ? this.resourceRepositoryAdapter.getRepositoryInformation() : null;
    }

    @Override
    public RegistryEntry getParentRegistryEntry() {
        if (this.parentRegistryEntry != null) {
            return this.parentRegistryEntry;
        }
        ResourceInformation resourceInformation = this.getResourceInformation();
        String superResourceType = resourceInformation.getSuperResourceType();
        if (superResourceType != null && this.moduleRegistry.getResourceRegistry().hasEntry(superResourceType)) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Override
    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    @Override
    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry entry = this.getParentRegistryEntry(); entry != null; entry = entry.getParentRegistryEntry()) {
            if (!entry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T, I> ResourceRepository<T, I> getResourceRepositoryFacade() {
        return new ResourceRepositoryFacade(this, this.moduleRegistry);
    }

    @Override
    public PagingBehavior getPagingBehavior() {
        if (this.pagingBehavior == null) {
            ResourceInformation resourceInformation = this.getResourceInformation();
            Class<? extends PagingSpec> pagingSpecType = resourceInformation.getPagingSpecType();
            this.pagingBehavior = this.moduleRegistry.findPagingBehavior(pagingSpecType);
        }
        return this.pagingBehavior;
    }

    @Override
    public boolean hasResourceRepository() {
        RegistryEntry parent = this.getParentRegistryEntry();
        return parent == null || !parent.getResourceInformation().getResourcePath().equals(this.getResourceInformation().getResourcePath());
    }
}

