/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.internal.utils.MethodCache;
import io.crnk.core.engine.parser.ConstructorBasedParser;
import io.crnk.core.engine.parser.DefaultStringParsers;
import io.crnk.core.engine.parser.EnumStringMapper;
import io.crnk.core.engine.parser.JacksonStringMapper;
import io.crnk.core.engine.parser.MethodBasedMapper;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.StringParser;
import io.crnk.core.engine.parser.ToStringStringMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeParser.class);
    public final Map<Class, StringParser> parsers;
    public final Map<Class, StringMapper> mappers;
    private MethodCache methodCache = new MethodCache();
    private boolean useJackson = true;
    private boolean enforceJackson = true;
    private ObjectMapper objectMapper;

    public TypeParser() {
        this.parsers = new ConcurrentHashMap<Class, StringParser>();
        this.mappers = new ConcurrentHashMap<Class, StringMapper>();
        this.mappers.putAll(DefaultStringParsers.get());
        this.parsers.putAll(this.mappers);
    }

    public boolean isEnforceJackson() {
        return this.enforceJackson;
    }

    public void setEnforceJackson(boolean enforceJackson) {
        this.enforceJackson = enforceJackson;
    }

    public boolean isUseJackson() {
        return this.useJackson;
    }

    public void setUseJackson(boolean useJackson) {
        this.useJackson = useJackson;
    }

    private static <T> boolean isEnum(Class<T> clazz) {
        return clazz.isEnum();
    }

    public <T> void addParser(Class<T> clazz, StringParser<T> parser) {
        this.parsers.put(clazz, parser);
    }

    public <T> void addMapper(Class<T> clazz, StringMapper<T> mapper) {
        this.addParser(clazz, mapper);
        this.mappers.put(clazz, mapper);
    }

    public <T> Iterable<T> parse(Iterable<String> inputs, Class<T> clazz) {
        LinkedList<T> parsedValues = new LinkedList<T>();
        for (String input : inputs) {
            parsedValues.add(this.parse(input, clazz));
        }
        return parsedValues;
    }

    public <T> T parse(String input, Class<T> clazz) {
        try {
            if (String.class.equals(clazz)) {
                return (T)input;
            }
            StringParser<T> parser = this.getParser(clazz, input);
            if (parser == null) {
                throw new ParserException(String.format("Cannot parse to %s : %s", clazz.getName(), input));
            }
            return parser.parse(input);
        }
        catch (NumberFormatException e) {
            throw new ParserException(e.getMessage());
        }
    }

    public String toString(Object input) {
        if (input == null) {
            return null;
        }
        Class<?> clazz = input.getClass();
        if (String.class.equals(clazz)) {
            return (String)input;
        }
        StringMapper<?> mapper = this.getMapper(clazz);
        if (mapper == null) {
            throw new ParserException(String.format("Cannot map to %s : %s", clazz.getName(), input));
        }
        return mapper.toString(input);
    }

    public <T> StringMapper<T> getMapper(Class<T> clazz) {
        if (this.mappers.containsKey(clazz)) {
            return this.mappers.get(clazz);
        }
        StringMapper<T> mapper = this.setupMapper(clazz);
        if (mapper != null) {
            LOGGER.debug("using mapper {} for type {}", mapper, clazz);
            this.mappers.put(clazz, mapper);
            return mapper;
        }
        return null;
    }

    private <T> StringParser<T> getParser(Class<T> clazz, String input) {
        if (this.parsers.containsKey(clazz)) {
            return this.parsers.get(clazz);
        }
        StringParser<T> parser = this.setupParser(clazz, input);
        if (parser != null) {
            LOGGER.debug("using parser {} for type {}", parser, clazz);
            this.parsers.put(clazz, parser);
            return parser;
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return this.getParser(clazz, null) != null;
    }

    private <T> StringMapper<T> setupMapper(Class<T> clazz) {
        if (this.mappers.containsKey(clazz)) {
            return this.mappers.get(clazz);
        }
        if (TypeParser.isEnum(clazz)) {
            return new EnumStringMapper<T>(clazz);
        }
        if (this.useJackson) {
            return new JacksonStringMapper(this.objectMapper, clazz);
        }
        return new ToStringStringMapper<T>(){

            @Override
            public T parse(String input) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private <T> StringParser<T> setupParser(Class<T> clazz, String input) {
        if (this.parsers.containsKey(clazz)) {
            return this.parsers.get(clazz);
        }
        if (TypeParser.isEnum(clazz)) {
            return new EnumStringMapper<T>(clazz);
        }
        if (this.enforceJackson) {
            return new JacksonStringMapper(this.objectMapper, clazz);
        }
        if (this.useJackson && input != null) {
            try {
                JacksonStringMapper parser = new JacksonStringMapper(this.objectMapper, clazz);
                parser.parse(input);
                return parser;
            }
            catch (RuntimeException e) {
                if (this.enforceJackson) {
                    throw new ParserException(String.format("Cannot parse '%s' tp type=%s", new Object[0]));
                }
                LOGGER.debug("Jackson not applicable to {} based on input {}", clazz, (Object)input);
                LOGGER.trace("Jackson error", (Throwable)e);
            }
        }
        try {
            if (this.containsStringConstructor(clazz)) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(String.class);
                return new ConstructorBasedParser(constructor);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        Optional<Method> method = this.methodCache.find(clazz, "parse", String.class);
        if (!method.isPresent()) {
            method = this.methodCache.find(clazz, "parse", CharSequence.class);
        }
        if (method.isPresent()) {
            return new MethodBasedMapper(method.get(), clazz);
        }
        return null;
    }

    private boolean containsStringConstructor(Class<?> clazz) {
        boolean result = false;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers()) || constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != String.class) continue;
            result = true;
        }
        return result;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> StringParser<T> getParser(Class<T> clazz) {
        return this.parsers.get(clazz);
    }
}

