/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.InMemoryEvaluator;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpecVisitor;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class QuerySpec {
    private Class<?> resourceClass;
    private String resourceType;
    private List<FilterSpec> filters = new ArrayList<FilterSpec>();
    private List<SortSpec> sort = new ArrayList<SortSpec>();
    private List<IncludeFieldSpec> includedFields = new ArrayList<IncludeFieldSpec>();
    private List<IncludeRelationSpec> includedRelations = new ArrayList<IncludeRelationSpec>();
    private Map<String, QuerySpec> typeRelatedSpecs = new HashMap<String, QuerySpec>();
    private Map<Class<?>, QuerySpec> classRelatedSpecs = new HashMap();
    private PagingSpec pagingSpec;

    public QuerySpec(Class<?> resourceClass) {
        this(resourceClass, null);
    }

    public QuerySpec(String resourceType) {
        this(null, resourceType);
    }

    public QuerySpec(Class<?> resourceClass, String resourceType) {
        QuerySpec.verifyNotNull(resourceClass, resourceType);
        if (resourceClass != Resource.class) {
            this.resourceClass = resourceClass;
        }
        if (resourceType == null) {
            JsonApiResource annotation = resourceClass.getAnnotation(JsonApiResource.class);
            if (annotation != null) {
                this.resourceType = annotation.type();
            }
        } else {
            this.resourceType = resourceType;
        }
        this.pagingSpec = new OffsetLimitPagingSpec();
    }

    public QuerySpec(ResourceInformation resourceInformation) {
        this(resourceInformation.getResourceClass(), resourceInformation.getResourceType());
    }

    public void accept(QuerySpecVisitor visitor) {
        if (visitor.visitStart(this)) {
            this.visitFilters(visitor, this.filters);
            for (SortSpec sortSpec : this.sort) {
                if (!visitor.visitSort(sortSpec)) continue;
                visitor.visitPath(sortSpec.getPath());
            }
            for (IncludeFieldSpec includeFieldSpec : this.includedFields) {
                if (!visitor.visitField(includeFieldSpec)) continue;
                visitor.visitPath(includeFieldSpec.getPath());
            }
            for (IncludeRelationSpec includeRelationSpec : this.includedRelations) {
                if (!visitor.visitInclude(includeRelationSpec)) continue;
                visitor.visitPath(includeRelationSpec.getPath());
            }
            if (this.pagingSpec != null) {
                visitor.visitPaging(this.pagingSpec);
            }
            this.typeRelatedSpecs.values().forEach(it -> it.accept(visitor));
            this.classRelatedSpecs.values().forEach(it -> it.accept(visitor));
            visitor.visitEnd(this);
        }
    }

    private void visitFilters(QuerySpecVisitor visitor, List<FilterSpec> filters) {
        for (FilterSpec spec : filters) {
            if (!visitor.visitFilterStart(spec)) continue;
            if (spec.hasExpressions()) {
                this.visitFilters(visitor, spec.getExpression());
            } else {
                visitor.visitPath(spec.getPath());
            }
            visitor.visitFilterEnd(spec);
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public <T> DefaultResourceList<T> apply(Iterable<T> resources) {
        DefaultResourceList resultList = new DefaultResourceList();
        resultList.setMeta(new DefaultPagedMetaInformation());
        this.apply(resources, resultList);
        return resultList;
    }

    public <T> void apply(Iterable<T> resources, ResourceList<T> resultList) {
        InMemoryEvaluator eval = new InMemoryEvaluator();
        eval.eval(resources, this, resultList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 31 * result + (this.includedFields == null ? 0 : this.includedFields.hashCode());
        result = 31 * result + (this.includedRelations == null ? 0 : this.includedRelations.hashCode());
        result = 31 * result + (this.pagingSpec == null ? 0 : this.pagingSpec.hashCode());
        result = 31 * result + (this.typeRelatedSpecs == null ? 0 : this.typeRelatedSpecs.hashCode());
        result = 31 * result + (this.classRelatedSpecs == null ? 0 : this.classRelatedSpecs.hashCode());
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpec other = (QuerySpec)obj;
        return CompareUtils.isEquals(this.filters, other.filters) && CompareUtils.isEquals(this.includedFields, other.includedFields) && CompareUtils.isEquals(this.includedRelations, other.includedRelations) && CompareUtils.isEquals(this.pagingSpec, other.pagingSpec) && CompareUtils.isEquals(this.typeRelatedSpecs, other.typeRelatedSpecs) && CompareUtils.isEquals(this.classRelatedSpecs, other.classRelatedSpecs) && CompareUtils.isEquals(this.sort, other.sort);
    }

    public Long getLimit() {
        OffsetLimitPagingSpec offsetLimitPagingSpec = this.getPaging(OffsetLimitPagingSpec.class);
        return offsetLimitPagingSpec.getLimit();
    }

    public void setLimit(Long limit) {
        OffsetLimitPagingSpec offsetLimitPagingSpec = this.getPaging(OffsetLimitPagingSpec.class);
        offsetLimitPagingSpec.setLimit(limit);
    }

    public long getOffset() {
        OffsetLimitPagingSpec offsetLimitPagingSpec = this.getPaging(OffsetLimitPagingSpec.class);
        return offsetLimitPagingSpec.getOffset();
    }

    public void setOffset(long offset) {
        OffsetLimitPagingSpec offsetLimitPagingSpec = this.getPaging(OffsetLimitPagingSpec.class);
        offsetLimitPagingSpec.setOffset(offset);
    }

    public PagingSpec getPaging() {
        return this.pagingSpec;
    }

    public <T extends PagingSpec> T getPaging(Class<T> pagingSpecType) {
        if (this.pagingSpec == null) {
            return null;
        }
        if (pagingSpecType.isInstance(this.pagingSpec)) {
            return (T)this.pagingSpec;
        }
        return this.pagingSpec.convert(pagingSpecType);
    }

    public QuerySpec setPaging(PagingSpec pagingSpec) {
        this.pagingSpec = pagingSpec;
        return this;
    }

    public List<FilterSpec> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterSpec> filters) {
        this.filters = filters;
    }

    public Optional<FilterSpec> findFilter(PathSpec pathSpec) {
        for (FilterSpec filterSpec : this.filters) {
            if (!filterSpec.getPath().equals(pathSpec)) continue;
            return Optional.of(filterSpec);
        }
        return Optional.empty();
    }

    public Optional<FilterSpec> findFilter(PathSpec pathSpec, FilterOperator operator) {
        for (FilterSpec filterSpec : this.filters) {
            if (!filterSpec.getPath().equals(pathSpec) || !operator.equals(filterSpec.getOperator())) continue;
            return Optional.of(filterSpec);
        }
        return Optional.empty();
    }

    public List<SortSpec> getSort() {
        return this.sort;
    }

    public void setSort(List<SortSpec> sort) {
        this.sort = sort;
    }

    public List<IncludeFieldSpec> getIncludedFields() {
        return this.includedFields;
    }

    public void setIncludedFields(List<IncludeFieldSpec> includedFields) {
        this.includedFields = includedFields;
    }

    public List<IncludeRelationSpec> getIncludedRelations() {
        return this.includedRelations;
    }

    public void setIncludedRelations(List<IncludeRelationSpec> includedRelations) {
        this.includedRelations = includedRelations;
    }

    public Collection<QuerySpec> getNestedSpecs() {
        HashSet<QuerySpec> allRelatedSpecs = new HashSet<QuerySpec>(this.typeRelatedSpecs.values());
        allRelatedSpecs.addAll(this.classRelatedSpecs.values());
        return Collections.unmodifiableCollection(allRelatedSpecs);
    }

    public void setNestedSpecs(Collection<QuerySpec> specs) {
        this.typeRelatedSpecs.clear();
        this.classRelatedSpecs.clear();
        for (QuerySpec spec : specs) {
            if (spec.getResourceType() != null) {
                this.typeRelatedSpecs.put(spec.getResourceType(), spec);
            }
            if (spec.getResourceClass() == null) continue;
            this.classRelatedSpecs.put(spec.getResourceClass(), spec);
        }
    }

    public void addFilter(FilterSpec filterSpec) {
        this.filters.add(filterSpec);
    }

    public void addSort(SortSpec sortSpec) {
        this.sort.add(sortSpec);
    }

    public void includeField(List<String> attrPath) {
        this.includeField(PathSpec.of(attrPath));
    }

    public void includeField(PathSpec path) {
        this.includedFields.add(new IncludeFieldSpec(path));
    }

    public void includeRelation(List<String> attrPath) {
        this.includeRelation(PathSpec.of(attrPath));
    }

    public void includeRelation(PathSpec path) {
        this.includedRelations.add(new IncludeRelationSpec(path));
    }

    public QuerySpec getQuerySpec(String resourceType) {
        if (resourceType.equals(this.resourceType)) {
            return this;
        }
        return this.typeRelatedSpecs.get(resourceType);
    }

    public QuerySpec getQuerySpec(Class<?> resourceClass) {
        if (resourceClass.equals(this.resourceClass)) {
            return this;
        }
        return this.classRelatedSpecs.get(resourceClass);
    }

    public QuerySpec getQuerySpec(ResourceInformation resourceInformation) {
        QuerySpec querySpec = this.getQuerySpec(resourceInformation.getResourceType());
        if (querySpec == null) {
            querySpec = this.getQuerySpec(resourceInformation.getResourceClass());
        }
        return querySpec;
    }

    public QuerySpec getOrCreateQuerySpec(String resourceType) {
        return this.getOrCreateQuerySpec(null, resourceType);
    }

    public QuerySpec getOrCreateQuerySpec(ResourceInformation resourceInformation) {
        return this.getOrCreateQuerySpec(resourceInformation.getResourceClass(), resourceInformation.getResourceType());
    }

    public QuerySpec getOrCreateQuerySpec(Class<?> targetResourceClass) {
        return this.getOrCreateQuerySpec(targetResourceClass, null);
    }

    public QuerySpec getOrCreateQuerySpec(Class<?> targetResourceClass, String targetResourceType) {
        QuerySpec.verifyNotNull(targetResourceClass, targetResourceType);
        QuerySpec querySpec = null;
        if (targetResourceType != null) {
            querySpec = this.getQuerySpec(targetResourceType);
            if (querySpec == null) {
                querySpec = new QuerySpec(targetResourceClass, targetResourceType);
                this.typeRelatedSpecs.put(targetResourceType, querySpec);
                if (targetResourceClass != null) {
                    this.classRelatedSpecs.put(targetResourceClass, querySpec);
                }
            }
        } else {
            querySpec = this.getQuerySpec(targetResourceClass);
            if (querySpec == null) {
                querySpec = new QuerySpec(targetResourceClass);
                this.classRelatedSpecs.put(targetResourceClass, querySpec);
            }
        }
        querySpec.setPaging(this.pagingSpec);
        return querySpec;
    }

    private static void verifyNotNull(Class<?> targetResourceClass, String targetResourceType) {
        PreconditionUtil.verify(targetResourceClass != null || targetResourceType != null, "at least one parameter must not be null", new Object[0]);
        if (targetResourceClass == Resource.class && targetResourceType == null) {
            throw new IllegalArgumentException("must specify resourceType if io.crnk.core.engine.document.Resource is used");
        }
    }

    public void putRelatedSpec(Class<?> relatedResourceClass, QuerySpec relatedSpec) {
        if (relatedResourceClass.equals(this.resourceClass)) {
            throw new IllegalArgumentException("cannot set related spec with root resourceClass");
        }
        this.classRelatedSpecs.put(relatedResourceClass, relatedSpec);
    }

    public QuerySpec clone() {
        QuerySpec copy = new QuerySpec(this.resourceClass, this.resourceType);
        if (this.pagingSpec != null) {
            copy.pagingSpec = this.pagingSpec.clone();
        }
        for (IncludeFieldSpec includeFieldSpec : this.includedFields) {
            copy.includedFields.add(includeFieldSpec.clone());
        }
        for (IncludeRelationSpec includeRelationSpec : this.includedRelations) {
            copy.includedRelations.add(includeRelationSpec.clone());
        }
        for (SortSpec sortSpec : this.sort) {
            copy.sort.add(sortSpec.clone());
        }
        for (FilterSpec filterSpec : this.filters) {
            copy.filters.add(filterSpec.clone());
        }
        for (Map.Entry entry : this.typeRelatedSpecs.entrySet()) {
            copy.typeRelatedSpecs.put((String)entry.getKey(), ((QuerySpec)entry.getValue()).clone());
        }
        for (Map.Entry entry : this.classRelatedSpecs.entrySet()) {
            copy.classRelatedSpecs.put((Class<?>)entry.getKey(), ((QuerySpec)entry.getValue()).clone());
        }
        return copy;
    }

    public String toString() {
        return "QuerySpec[" + (this.resourceClass != null ? "resourceClass=" + this.resourceClass.getName() : "") + (this.resourceType != null && this.resourceClass != null ? ", " : "") + (this.resourceType != null ? "resourceType=" + this.resourceType : "") + (this.pagingSpec != null ? ", paging=" + this.pagingSpec : "") + (!this.filters.isEmpty() ? ", filters=" + this.filters : "") + (!this.sort.isEmpty() ? ", sort=" + this.sort : "") + (!this.includedFields.isEmpty() ? ", includedFields=" + this.includedFields : "") + (!this.includedRelations.isEmpty() ? ", includedRelations=" + this.includedRelations : "") + (!this.typeRelatedSpecs.isEmpty() ? ", typeRelatedSpecs=" + this.typeRelatedSpecs : "") + (!this.classRelatedSpecs.isEmpty() ? ", classRelatedSpecs=" + this.classRelatedSpecs : "") + ']';
    }
}

