/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QuerySpecAdapter
implements QueryAdapter {
    private final QueryContext queryContext;
    private QuerySpec querySpec;
    private ResourceRegistry resourceRegistry;
    private boolean compactMode;
    private boolean isSelfLink;

    public QuerySpecAdapter(QuerySpec querySpec, ResourceRegistry resourceRegistry, QueryContext queryContext) {
        this.querySpec = querySpec;
        this.resourceRegistry = resourceRegistry;
        this.queryContext = queryContext;
        if (queryContext != null && queryContext.getRequestPath() != null) {
            this.isSelfLink = queryContext.getRequestPath().contains("/relationships");
        }
    }

    public QuerySpec getQuerySpec() {
        return this.querySpec;
    }

    @Override
    public Map<String, Set<PathSpec>> getIncludedRelations() {
        HashMap<String, Set<PathSpec>> params = new HashMap<String, Set<PathSpec>>();
        if (this.querySpec != null) {
            this.addRelations(params, this.querySpec);
            for (QuerySpec relatedSpec : this.querySpec.getNestedSpecs()) {
                this.addRelations(params, relatedSpec);
            }
        }
        return params;
    }

    private void addRelations(Map<String, Set<PathSpec>> params, QuerySpec spec) {
        if (!spec.getIncludedRelations().isEmpty()) {
            HashSet<PathSpec> set = new HashSet<PathSpec>();
            for (IncludeRelationSpec relation : spec.getIncludedRelations()) {
                set.add(relation.getPath());
            }
            params.put(this.getResourceType(spec), set);
        }
    }

    private String getResourceType(QuerySpec spec) {
        if (spec.getResourceType() != null) {
            return spec.getResourceType();
        }
        RegistryEntry entry = this.resourceRegistry.getEntry(spec.getResourceClass());
        ResourceInformation resourceInformation = entry.getResourceInformation();
        return resourceInformation.getResourceType();
    }

    @Override
    public Map<String, Set<PathSpec>> getIncludedFields() {
        HashMap<String, Set<PathSpec>> params = new HashMap<String, Set<PathSpec>>();
        if (this.querySpec != null) {
            this.addFields(params, this.querySpec);
            for (QuerySpec relatedSpec : this.querySpec.getNestedSpecs()) {
                this.addFields(params, relatedSpec);
            }
        }
        return params;
    }

    private void addFields(Map<String, Set<PathSpec>> params, QuerySpec spec) {
        if (!spec.getIncludedFields().isEmpty()) {
            HashSet<PathSpec> set = new HashSet<PathSpec>();
            for (IncludeFieldSpec relation : spec.getIncludedFields()) {
                set.add(relation.getPath());
            }
            params.put(this.getResourceType(spec), set);
        }
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceRegistry.getEntry(this.getResourceType(this.querySpec)).getResourceInformation();
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    @Override
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Override
    public QueryAdapter duplicate() {
        QuerySpecAdapter adapter = new QuerySpecAdapter(this.querySpec != null ? this.querySpec.clone() : null, this.resourceRegistry, this.queryContext);
        adapter.setCompactMode(this.compactMode);
        return adapter;
    }

    @Override
    public QuerySpec toQuerySpec() {
        return this.getQuerySpec();
    }

    @Override
    public boolean getCompactMode() {
        return this.compactMode;
    }

    @Override
    public void setPagingSpec(PagingSpec pagingSpec) {
        this.querySpec.setPaging(pagingSpec);
    }

    @Override
    public PagingSpec getPagingSpec() {
        return this.querySpec.getPaging();
    }

    @Override
    public boolean isEmpty() {
        return this.querySpec == null;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public String toString() {
        return this.querySpec.toString();
    }

    @Override
    public boolean isSelfLink() {
        return this.isSelfLink;
    }
}

