/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.pagingspec;

import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.module.Module;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.queryspec.pagingspec.NumberSizePagingSpec;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingBehaviorBase;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpecUrlBuilder;
import io.crnk.core.resource.links.PagedLinksInformation;
import io.crnk.core.resource.list.ResourceList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NumberSizePagingBehavior
extends PagingBehaviorBase<NumberSizePagingSpec> {
    private static final String NUMBER_PARAMETER = "number";
    private static final String SIZE_PARAMETER = "size";
    private int defaultNumber = 1;

    @Override
    public boolean supports(Class<? extends PagingSpec> pagingSpecType) {
        return pagingSpecType.isAssignableFrom(NumberSizePagingSpec.class) || pagingSpecType == OffsetLimitPagingSpec.class;
    }

    @Override
    public Map<String, Set<String>> serialize(NumberSizePagingSpec pagingSpec, String resourceType) {
        HashMap<String, Set<String>> values = new HashMap<String, Set<String>>();
        if (pagingSpec.getSize() != null || pagingSpec.getNumber() != 1) {
            values.put(String.format("page[%s]", NUMBER_PARAMETER), new HashSet<String>(Arrays.asList(Long.toString(pagingSpec.getNumber()))));
        }
        if (pagingSpec.getSize() != null) {
            values.put(String.format("page[%s]", SIZE_PARAMETER), new HashSet<String>(Arrays.asList(Long.toString(pagingSpec.getSize().intValue()))));
        }
        return values;
    }

    @Override
    public NumberSizePagingSpec deserialize(Map<String, Set<String>> parameters) {
        NumberSizePagingSpec result = this.createDefaultPagingSpec();
        for (Map.Entry<String, Set<String>> param : parameters.entrySet()) {
            if (NUMBER_PARAMETER.equalsIgnoreCase(param.getKey())) {
                result.setNumber(this.getValue(param.getKey(), param.getValue()).intValue());
                continue;
            }
            if (SIZE_PARAMETER.equalsIgnoreCase(param.getKey())) {
                Long size = this.getValue(param.getKey(), param.getValue());
                if (this.maxPageLimit != null && size != null && size > this.maxPageLimit) {
                    throw new BadRequestException(String.format("%s value %d is larger than the maximum allowed of %d", SIZE_PARAMETER, size, this.maxPageLimit));
                }
                result.setSize(size.intValue());
                continue;
            }
            throw new ParametersDeserializationException(param.getKey());
        }
        return result;
    }

    @Override
    public NumberSizePagingSpec createEmptyPagingSpec() {
        return new NumberSizePagingSpec();
    }

    @Override
    public NumberSizePagingSpec createDefaultPagingSpec() {
        return new NumberSizePagingSpec(this.defaultNumber, this.defaultLimit != null ? Integer.valueOf(this.defaultLimit.intValue()) : null);
    }

    @Override
    public void build(PagedLinksInformation linksInformation, ResourceList<?> resources, QueryAdapter queryAdapter, PagingSpecUrlBuilder urlBuilder) {
        Long totalCount = this.getTotalCount(resources);
        Boolean isNextPageAvailable = this.isNextPageAvailable(resources);
        if (!(totalCount == null && isNextPageAvailable == null || this.hasPageLinks(linksInformation))) {
            boolean hasResults = resources.iterator().hasNext();
            this.doEnrichPageLinksInformation(linksInformation, totalCount, isNextPageAvailable, queryAdapter, hasResults, urlBuilder);
        }
    }

    @Override
    public boolean isRequired(NumberSizePagingSpec pagingSpec) {
        return pagingSpec.getNumber() != 1 || pagingSpec.getSize() != null;
    }

    private void doEnrichPageLinksInformation(PagedLinksInformation linksInformation, Long total, Boolean isNextPageAvailable, QueryAdapter queryAdapter, boolean hasResults, PagingSpecUrlBuilder urlBuilder) {
        NumberSizePagingSpec pagingSpec = (NumberSizePagingSpec)queryAdapter.getPagingSpec();
        int size = pagingSpec.getSize();
        int number = pagingSpec.getNumber();
        if (total != null) {
            isNextPageAvailable = (long)(size * number) < total;
        }
        if (number > 1 || hasResults) {
            Long totalPages = total != null ? Long.valueOf((total + (long)size - 1L) / (long)size) : null;
            QueryAdapter pageSpec = queryAdapter.duplicate();
            pageSpec.setPagingSpec(new NumberSizePagingSpec(1, size));
            linksInformation.setFirst(urlBuilder.build(pageSpec));
            if (totalPages != null && totalPages > 0L) {
                pageSpec.setPagingSpec(new NumberSizePagingSpec(totalPages.intValue(), size));
                linksInformation.setLast(urlBuilder.build(pageSpec));
            }
            if (number > 1) {
                pageSpec.setPagingSpec(new NumberSizePagingSpec(number - 1, size));
                linksInformation.setPrev(urlBuilder.build(pageSpec));
            }
            if (isNextPageAvailable.booleanValue()) {
                pageSpec.setPagingSpec(new NumberSizePagingSpec(number + 1, size));
                linksInformation.setNext(urlBuilder.build(pageSpec));
            }
        }
    }

    public void setDefaultNumber(int defaultNumber) {
        this.defaultNumber = defaultNumber;
    }

    public static Module createModule() {
        SimpleModule module = new SimpleModule("numberPaging");
        module.addPagingBehavior(new NumberSizePagingBehavior());
        return module;
    }
}

