/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.filter.AbstractDocumentFilter;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.filter.DocumentFilterContext;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.transaction.TransactionRunner;
import io.crnk.core.module.InitializingModule;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepository;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.meta.DefaultHasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import io.crnk.data.jpa.JpaEntityRepository;
import io.crnk.data.jpa.JpaModuleConfig;
import io.crnk.data.jpa.JpaRepositoryConfig;
import io.crnk.data.jpa.JpaRepositoryFactory;
import io.crnk.data.jpa.JpaRepositoryFilter;
import io.crnk.data.jpa.internal.JpaRepositoryConfigSupplier;
import io.crnk.data.jpa.internal.JpaRepositoryUtils;
import io.crnk.data.jpa.internal.JpaRequestContext;
import io.crnk.data.jpa.internal.JpaResourceInformationProvider;
import io.crnk.data.jpa.internal.OptimisticLockExceptionMapper;
import io.crnk.data.jpa.internal.PersistenceExceptionMapper;
import io.crnk.data.jpa.internal.PersistenceRollbackExceptionMapper;
import io.crnk.data.jpa.internal.query.backend.querydsl.QuerydslQueryImpl;
import io.crnk.data.jpa.meta.JpaMetaProvider;
import io.crnk.data.jpa.meta.MetaEntity;
import io.crnk.data.jpa.meta.internal.JpaMetaEnricher;
import io.crnk.data.jpa.meta.internal.JpaMetaPartition;
import io.crnk.data.jpa.query.JpaQueryFactory;
import io.crnk.data.jpa.query.JpaQueryFactoryContext;
import io.crnk.data.jpa.query.querydsl.QuerydslQueryFactory;
import io.crnk.data.jpa.query.querydsl.QuerydslRepositoryFilter;
import io.crnk.data.jpa.query.querydsl.QuerydslTranslationContext;
import io.crnk.data.jpa.query.querydsl.QuerydslTranslationInterceptor;
import io.crnk.meta.MetaLookup;
import io.crnk.meta.MetaLookupImpl;
import io.crnk.meta.MetaModuleExtension;
import io.crnk.meta.model.MetaAttribute;
import io.crnk.meta.provider.MetaPartition;
import io.crnk.meta.provider.MetaProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaModule
implements InitializingModule {
    private static final String MODULE_NAME = "jpa";
    private Logger logger = LoggerFactory.getLogger(JpaModule.class);
    private EntityManagerFactory emFactory;
    private Supplier<EntityManager> emSupplier;
    private TransactionRunner transactionRunner;
    private Module.ModuleContext context;
    private JpaModuleConfig config;
    private JpaMetaEnricher metaEnricher;
    private MetaLookupImpl jpaMetaLookup;
    private JpaMetaProvider jpaMetaProvider;

    protected JpaModule() {
    }

    private JpaModule(JpaModuleConfig config, EntityManagerFactory emFactory, Supplier<EntityManager> em, TransactionRunner transactionRunner) {
        this();
        this.config = config;
        this.emFactory = emFactory;
        this.emSupplier = em;
        this.transactionRunner = transactionRunner;
    }

    public static JpaModule newClientModule() {
        return new JpaModule();
    }

    public static JpaModule createServerModule(JpaModuleConfig config, EntityManager em, TransactionRunner transactionRunner) {
        return JpaModule.createServerModule(config, () -> em, transactionRunner);
    }

    public static JpaModule createServerModule(JpaModuleConfig config, Supplier<EntityManager> em, TransactionRunner transactionRunner) {
        return new JpaModule(config, null, em, transactionRunner);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public void setupModule(Module.ModuleContext context) {
        this.context = context;
        HashSet<Class> jpaTypes = new HashSet<Class>();
        if (this.config != null) {
            for (JpaRepositoryConfig config : this.config.getRepositories()) {
                jpaTypes.add(config.getEntityClass());
            }
        }
        this.jpaMetaProvider = new JpaMetaProvider(jpaTypes);
        this.jpaMetaLookup = new MetaLookupImpl();
        this.jpaMetaLookup.addProvider((MetaProvider)this.jpaMetaProvider);
        this.jpaMetaLookup.setModuleContext(context);
        this.jpaMetaLookup.initialize();
        if (this.config != null) {
            this.initQueryFactory();
            context.addResourceInformationProvider(this.config.getResourceInformationProvider(context.getPropertiesProvider()));
        } else {
            context.addResourceInformationProvider((ResourceInformationProvider)new JpaResourceInformationProvider());
        }
        context.addExceptionMapper((ExceptionMapper)new OptimisticLockExceptionMapper());
        context.addExceptionMapper((ExceptionMapper)new PersistenceExceptionMapper(context));
        context.addExceptionMapper((ExceptionMapper)new PersistenceRollbackExceptionMapper(context));
        this.addHibernateConstraintViolationExceptionMapper();
        this.addTransactionRollbackExceptionMapper();
        if (this.emSupplier != null) {
            this.metaEnricher = new JpaMetaEnricher();
            MetaModuleExtension metaModuleExtension = new MetaModuleExtension();
            metaModuleExtension.addProvider(this.metaEnricher.getProvider());
            context.addExtension((ModuleExtension)metaModuleExtension);
            this.setupTransactionMgmt();
            this.setupFacetExtension(context);
        }
    }

    private void setupFacetExtension(Module.ModuleContext context) {
        if (ClassUtils.existsClass((String)"io.crnk.data.facet.FacetModuleExtension")) {
            ExceptionUtil.wrapCatchedExceptions(() -> {
                Class<?> clazz = Class.forName("io.crnk.data.jpa.internal.facet.JpaFacetModuleExtensionFactory");
                Method method = clazz.getMethod("create", new Class[0]);
                ModuleExtension homeExtension = (ModuleExtension)method.invoke(clazz, new Object[0]);
                context.addExtension(homeExtension);
                return null;
            });
        }
    }

    private void initQueryFactory() {
        JpaQueryFactory queryFactory = this.config.getQueryFactory();
        queryFactory.initalize(new JpaQueryFactoryContext(){

            @Override
            public EntityManager getEntityManager() {
                return (EntityManager)JpaModule.this.emSupplier.get();
            }

            @Override
            public MetaPartition getMetaPartition() {
                return JpaModule.this.jpaMetaProvider.getPartition();
            }
        });
        if (queryFactory instanceof QuerydslQueryFactory) {
            QuerydslQueryFactory querydslFactory = (QuerydslQueryFactory)queryFactory;
            querydslFactory.addInterceptor(new JpaQuerydslTranslationInterceptor());
        }
    }

    public void init() {
        if (this.emSupplier != null) {
            this.setupServerRepositories();
        }
    }

    private void addHibernateConstraintViolationExceptionMapper() {
        if (ClassUtils.existsClass((String)"org.hibernate.exception.ConstraintViolationException")) {
            ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Class<?> mapperClass = Class.forName("io.crnk.data.jpa.internal.HibernateConstraintViolationExceptionMapper");
                    Constructor<?> constructor = mapperClass.getConstructor(new Class[0]);
                    ExceptionMapper mapper = (ExceptionMapper)constructor.newInstance(new Object[0]);
                    JpaModule.this.context.addExceptionMapper(mapper);
                    return null;
                }
            });
        }
    }

    private void addTransactionRollbackExceptionMapper() {
        if (ClassUtils.existsClass((String)"javax.transaction.RollbackException")) {
            ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Class<?> mapperClass = Class.forName("io.crnk.data.jpa.internal.TransactionRollbackExceptionMapper");
                    Constructor<?> constructor = mapperClass.getConstructor(Module.ModuleContext.class);
                    ExceptionMapper mapper = (ExceptionMapper)constructor.newInstance(JpaModule.this.context);
                    JpaModule.this.context.addExceptionMapper(mapper);
                    return null;
                }
            });
        }
    }

    protected void setupTransactionMgmt() {
        this.context.addFilter((DocumentFilter)new AbstractDocumentFilter(){

            public Response filter(final DocumentFilterContext context, final DocumentFilterChain chain) {
                return (Response)JpaModule.this.transactionRunner.doInTransaction((Callable)new Callable<Response>(){

                    @Override
                    public Response call() {
                        return chain.doFilter(context);
                    }
                });
            }
        });
    }

    private void setupServerRepositories() {
        this.metaEnricher.setMetaProvider(this.jpaMetaProvider);
        ArrayList<JpaRepositoryConfig> customConfig = new ArrayList<JpaRepositoryConfig>();
        Collection repositories = this.context.getModuleRegistry().getRepositories();
        for (Object repository : repositories) {
            Object unwrappedRepository = JpaRepositoryUtils.unwrap(repository);
            if (!(unwrappedRepository instanceof JpaRepositoryConfigSupplier)) continue;
            JpaRepositoryConfigSupplier entityRepository = (JpaRepositoryConfigSupplier)unwrappedRepository;
            JpaRepositoryConfig repositoryConfig = entityRepository.getRepositoryConfig();
            JpaRepositoryUtils.setDefaultConfig(this.config, repositoryConfig);
            customConfig.add(repositoryConfig);
            MetaPartition partition = this.jpaMetaLookup.getPartition(JpaMetaPartition.class);
            partition.allocateMetaElement(repositoryConfig.getEntityClass());
        }
        for (JpaRepositoryConfig config : this.config.getRepositories()) {
            this.setupRepository(config);
        }
        customConfig.forEach(it -> this.config.addRepository(it));
    }

    private void setupRepository(JpaRepositoryConfig<?> repositoryConfig) {
        MetaEntity metaEntity;
        if (repositoryConfig.getListMetaClass() == DefaultPagedMetaInformation.class && !this.config.isTotalResourceCountUsed()) {
            repositoryConfig.setListMetaClass(DefaultHasMoreResourcesMetaInformation.class);
        }
        Class<?> resourceClass = repositoryConfig.getResourceClass();
        Class<?> entityClass = repositoryConfig.getEntityClass();
        try {
            metaEntity = (MetaEntity)((Object)this.jpaMetaProvider.getMeta(entityClass));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("failed to gather entity informations from " + entityClass + ", make sure it is probably annotated with JPA annotations", e);
        }
        if (this.isValidEntity(metaEntity)) {
            JpaRepositoryFactory repositoryFactory = this.config.getRepositoryFactory();
            JpaRepositoryUtils.setDefaultConfig(this.config, repositoryConfig);
            JpaEntityRepository jpaRepository = repositoryFactory.createEntityRepository(this, repositoryConfig);
            ResourceRepository<?, ?> repository = this.filterResourceCreation(resourceClass, jpaRepository);
            this.context.addRepository(repository);
        }
    }

    private ResourceRepository<?, ?> filterResourceCreation(Class<?> resourceClass, JpaEntityRepository<?, ?> repository) {
        JpaEntityRepository<?, ?> filteredRepository = repository;
        for (JpaRepositoryFilter filter : this.config.getFilters()) {
            if (!filter.accept(resourceClass)) continue;
            filteredRepository = filter.filterCreation(filteredRepository);
        }
        return filteredRepository;
    }

    private boolean isValidEntity(MetaEntity metaEntity) {
        for (MetaAttribute attribute : metaEntity.getAttributes()) {
            if (attribute.getAnnotation(JsonApiId.class) == null) continue;
            return true;
        }
        if (metaEntity.getPrimaryKey() == null) {
            this.logger.warn("{} has no primary key and will be ignored", (Object)metaEntity.getName());
            return false;
        }
        if (metaEntity.getPrimaryKey().getElements().size() > 1) {
            this.logger.warn("{} has a compound primary key and will be ignored", (Object)metaEntity.getName());
            return false;
        }
        return true;
    }

    public EntityManager getEntityManager() {
        return this.emSupplier.get();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emFactory;
    }

    public MetaLookup getJpaMetaLookup() {
        return this.jpaMetaLookup;
    }

    public boolean hasRepository(Class<?> resourceClass) {
        return this.config.hasRepository(resourceClass);
    }

    public JpaMetaProvider getJpaMetaProvider() {
        return this.jpaMetaProvider;
    }

    public JpaModuleConfig getConfig() {
        return this.config;
    }

    private final class JpaQuerydslTranslationInterceptor
    implements QuerydslTranslationInterceptor {
        private JpaQuerydslTranslationInterceptor() {
        }

        @Override
        public <T> void intercept(QuerydslQueryImpl<T> query, QuerydslTranslationContext<T> translationContext) {
            JpaRequestContext requestContext = (JpaRequestContext)query.getPrivateData();
            if (requestContext != null) {
                for (JpaRepositoryFilter filter : JpaModule.this.config.getFilters()) {
                    this.invokeFilter(filter, requestContext, translationContext);
                }
            }
        }

        private <T> void invokeFilter(JpaRepositoryFilter filter, JpaRequestContext requestContext, QuerydslTranslationContext<T> translationContext) {
            if (filter instanceof QuerydslRepositoryFilter) {
                Object repository = requestContext.getRepository();
                QuerySpec querySpec = requestContext.getQuerySpec();
                ((QuerydslRepositoryFilter)filter).filterQueryTranslation(repository, querySpec, translationContext);
            }
        }
    }
}

