/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.data.jpa;

import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.data.jpa.DefaultJpaRepositoryFactory;
import io.crnk.data.jpa.JpaRepositoryConfig;
import io.crnk.data.jpa.JpaRepositoryFactory;
import io.crnk.data.jpa.JpaRepositoryFilter;
import io.crnk.data.jpa.internal.JpaResourceInformationProvider;
import io.crnk.data.jpa.internal.QueryFactoryDiscovery;
import io.crnk.data.jpa.query.JpaQueryFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.ManagedType;

public class JpaModuleConfig {
    private JpaQueryFactory queryFactory;
    private List<JpaRepositoryFilter> filters = new CopyOnWriteArrayList<JpaRepositoryFilter>();
    private boolean totalResourceCountUsed = true;
    private JpaRepositoryFactory repositoryFactory = new DefaultJpaRepositoryFactory();
    private boolean relationshipsEnabled = false;
    private ResourceInformationProvider resourceInformationProvider;
    private Map<Class<?>, JpaRepositoryConfig<?>> repositoryConfigurationMap = new HashMap();

    protected ResourceInformationProvider getResourceInformationProvider(PropertiesProvider propertiesProvider) {
        if (this.resourceInformationProvider == null) {
            this.resourceInformationProvider = new JpaResourceInformationProvider(propertiesProvider);
        }
        return this.resourceInformationProvider;
    }

    public void setResourceInformationProvider(ResourceInformationProvider resourceInformationProvider) {
        PreconditionUtil.verify((this.resourceInformationProvider == null ? 1 : 0) != 0, (String)"already set", (Object[])new Object[0]);
        this.resourceInformationProvider = resourceInformationProvider;
    }

    public void setRepositoryFactory(JpaRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public JpaRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void addFilter(JpaRepositoryFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(JpaRepositoryFilter filter) {
        this.filters.remove(filter);
    }

    public List<JpaRepositoryFilter> getFilters() {
        return this.filters;
    }

    public boolean isTotalResourceCountUsed() {
        return this.totalResourceCountUsed;
    }

    public void setTotalResourceCountUsed(boolean totalResourceCountUsed) {
        this.totalResourceCountUsed = totalResourceCountUsed;
    }

    public boolean hasRepository(Class<?> resourceClass) {
        return this.repositoryConfigurationMap.containsKey(resourceClass);
    }

    public <T> JpaRepositoryConfig<T> getRepository(Class<T> resourceClass) {
        return this.repositoryConfigurationMap.get(resourceClass);
    }

    public Collection<JpaRepositoryConfig> getRepositories() {
        return this.repositoryConfigurationMap.values();
    }

    public <T> void addRepository(JpaRepositoryConfig<T> config) {
        Class<T> resourceClass = config.getResourceClass();
        if (this.repositoryConfigurationMap.containsKey(resourceClass)) {
            throw new IllegalStateException(resourceClass.getName() + " is already registered");
        }
        this.repositoryConfigurationMap.put(resourceClass, config);
    }

    public void exposeAllEntities(EntityManagerFactory emf) {
        Set managedTypes = emf.getMetamodel().getManagedTypes();
        for (ManagedType managedType : managedTypes) {
            Class managedJavaType = managedType.getJavaType();
            if (managedJavaType.getAnnotation(Entity.class) == null) continue;
            this.addRepository(JpaRepositoryConfig.builder(managedJavaType).build());
        }
    }

    public <T> void removeRepository(Class<T> resourceClass) {
        this.repositoryConfigurationMap.remove(resourceClass);
    }

    public void removeRepositories() {
        this.repositoryConfigurationMap.clear();
    }

    public Set<Class<?>> getResourceClasses() {
        return Collections.unmodifiableSet(this.repositoryConfigurationMap.keySet());
    }

    public JpaQueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            QueryFactoryDiscovery queryFactoryDiscovery = new QueryFactoryDiscovery();
            this.setQueryFactory(queryFactoryDiscovery.discoverDefaultFactory());
        }
        return this.queryFactory;
    }

    public void setQueryFactory(JpaQueryFactory queryFactory) {
        if (this.queryFactory != null) {
            throw new IllegalStateException("queryFactory already set");
        }
        this.queryFactory = queryFactory;
    }
}

